package com.crossingchannels.portal.websphere.ci.generic.types;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * Define define security subject as tuple of ID and type.
 * 
 * @author fwiegerinck
 */
public final class PortalSecuritySubject {

	private final String id;
	private final PortalSecuritySubjectType type;

	/**
	 * @param id
	 * @param type
	 */
	public PortalSecuritySubject(final String id, final PortalSecuritySubjectType type) {
		super();
		
		// Preconditions
		Validate.notEmpty(id);
		Validate.notNull(type);
		
		// Store
		this.id = id;
		this.type = type;
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @return the type
	 */
	public PortalSecuritySubjectType getType() {
		return type;
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(23, 31).append(this.id).append(this.type).toHashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		
		final PortalSecuritySubject other = (PortalSecuritySubject) obj;

		return new EqualsBuilder().append(id, other.id).append(type, other.type).isEquals();
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this).append("id", id).append("type", type).toString();
	}
	
	
}
