package com.crossingchannels.portal.websphere.ci.portlet.types;

import org.apache.commons.lang.Validate;

/**
 * Define object for localized information about a portlet
 * 
 * @author fwiegerinck
 */
public class LocalizedPortletInfo {

	private final String language;
	private final String title;
	private final String description;
	private final String keywords;
	
	/**
	 * @param language
	 * @param title
	 * @param description
	 * @param keywords
	 */
	public LocalizedPortletInfo(String language, String title, String description,
			String keywords) {
		super();
		
		// Preconditions
		Validate.notEmpty(language);
		
		// Store values
		this.language = language;
		this.title = title;
		this.description = description;
		this.keywords = keywords;
	}

	public String getLanguage() {
		return language;
	}

	public String getTitle() {
		return title;
	}

	public String getDescription() {
		return description;
	}

	public String getKeywords() {
		return keywords;
	}

}
