/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wps.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;

@Metadata(virtual=true, description="Websphere Process Server Ear Module")
public class BaseEarModule
extends ExtensibleDeployedArtifact {
    public static final String BPC_FORCE_UNDEPLOYMENT = "bpcForceUndeployment";
    @Property(hidden=true, required=false, description="Python script invoked to delete and stop process, task instances")
    private String deleteBpcTemplatesScript;
    @Property(hidden=true, defaultValue="9", description="The order in which  the delete and stop process, task instances step will be executed.")
    private int deleteBpcTemplatesScriptOrder;
    @Property(hidden=true, required=false, description="Python script invoked to stop process, task instances")
    private String stopBpcTemplatesScript;
    @Property(hidden=true, defaultValue="9", description="The order in which  stop process, task instances step will be executed.")
    private int stopBpcTemplatesScriptOrder;
    @Property(required=false, defaultValue="true", description="Stop process, task instances before undeployment.", category="WPS")
    private boolean stopProcessAndTaskTemplates = true;

    public void destroy(DeploymentPlanningContext ctx) {
        if (ctx.getDeployedApplication().hasProperty(BPC_FORCE_UNDEPLOYMENT)) {
            Boolean bpcForceUndeployment = (Boolean)ctx.getDeployedApplication().getProperty(BPC_FORCE_UNDEPLOYMENT);
            if (bpcForceUndeployment.booleanValue()) {
                this.addStep(ctx, this.deleteBpcTemplatesScriptOrder, this.deleteBpcTemplatesScript, "Deleting processes and tasks", false);
            } else if (this.stopProcessAndTaskTemplates) {
                this.addStep(ctx, this.stopBpcTemplatesScriptOrder, this.stopBpcTemplatesScript, "Stopping processes and tasks", false);
            }
        }
        super.destroy(ctx);
    }
}

