/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.configuration;

import com.google.inject.internal.util.;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.nnsoft.guice.rocoto.configuration.binder.XMLPropertiesFormatBindingBuilder;

final class PropertiesURLReader
implements XMLPropertiesFormatBindingBuilder {
    private final URL url;
    private boolean isXML = false;

    public PropertiesURLReader(URL url) {
        .Preconditions.checkNotNull((Object)url, (Object)"'url' argument can't be null");
        this.url = url;
    }

    public void inXMLFormat() {
        this.isXML = true;
    }

    public URL getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Properties readConfiguration() throws Exception {
        URLConnection connection = null;
        InputStream input = null;
        try {
            connection = this.url.openConnection();
            connection.setUseCaches(false);
            input = connection.getInputStream();
            Properties properties = new Properties();
            if (this.isXML) {
                properties.loadFromXML(input);
            } else {
                properties.load(input);
            }
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (connection != null && connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

