/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.suppliers;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.config.ClusterCompute;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.ec2.compute.domain.EC2HardwareBuilder;
import org.jclouds.ec2.compute.suppliers.EC2HardwareSupplier;

@Singleton
public class AWSEC2HardwareSupplier
extends EC2HardwareSupplier {
    private final Set<String> ccAmis;

    @Inject
    public AWSEC2HardwareSupplier(@ClusterCompute Set<String> ccAmis) {
        this.ccAmis = ccAmis;
    }

    public Set<? extends Hardware> get() {
        ImmutableSet.Builder sizes = ImmutableSet.builder();
        sizes.add((Object)EC2HardwareBuilder.cc1_4xlarge().supportsImageIds(this.ccAmis).build());
        sizes.add((Object)EC2HardwareBuilder.cg1_4xlarge().supportsImageIds(this.ccAmis).build());
        sizes.add((Object)EC2HardwareBuilder.cc2_8xlarge().supportsImageIds(this.ccAmis).build());
        sizes.add((Object)EC2HardwareBuilder.hi1_4xlarge().supportsImageIds(this.ccAmis).build());
        sizes.add((Object)EC2HardwareBuilder.hs1_8xlarge().supportsImageIds(this.ccAmis).build());
        sizes.add((Object)EC2HardwareBuilder.g2_2xlarge().supportsImageIds(this.ccAmis).build());
        sizes.add((Object)EC2HardwareBuilder.t1_micro().build());
        sizes.add((Object)EC2HardwareBuilder.c1_medium().build());
        sizes.add((Object)EC2HardwareBuilder.c1_xlarge().build());
        sizes.add((Object)EC2HardwareBuilder.c3_xlarge().build());
        sizes.add((Object)EC2HardwareBuilder.c3_2xlarge().build());
        sizes.add((Object)EC2HardwareBuilder.c3_4xlarge().build());
        sizes.add((Object)EC2HardwareBuilder.c3_8xlarge().build());
        sizes.add((Object)EC2HardwareBuilder.i2_xlarge().build());
        sizes.add((Object)EC2HardwareBuilder.i2_2xlarge().build());
        sizes.add((Object)EC2HardwareBuilder.i2_4xlarge().build());
        sizes.add((Object)EC2HardwareBuilder.i2_8xlarge().build());
        sizes.add((Object)EC2HardwareBuilder.m1_large().build());
        sizes.add((Object)EC2HardwareBuilder.m1_small().build());
        sizes.add((Object)EC2HardwareBuilder.m1_medium().build());
        sizes.add((Object)EC2HardwareBuilder.m1_xlarge().build());
        sizes.add((Object)EC2HardwareBuilder.m2_xlarge().build());
        sizes.add((Object)EC2HardwareBuilder.m2_2xlarge().build());
        sizes.add((Object)EC2HardwareBuilder.m2_4xlarge().build());
        sizes.add((Object)EC2HardwareBuilder.m3_medium().build());
        sizes.add((Object)EC2HardwareBuilder.m3_large().build());
        sizes.add((Object)EC2HardwareBuilder.m3_xlarge().build());
        sizes.add((Object)EC2HardwareBuilder.m3_2xlarge().build());
        return sizes.build();
    }
}

