package com.xebialabs.deployit.plugin.ec2.steps;

import java.util.ArrayList;
import java.util.Date;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.cloud.step.ContextAttribute;
import com.xebialabs.deployit.plugin.cloud.util.ContextHelper;
import com.xebialabs.deployit.plugin.ec2.access.EC2Adapter;
import com.xebialabs.deployit.plugin.ec2.ci.HostTemplate;

import static java.util.Arrays.asList;

/**
 * Step which actually starts node on EC2.
 */
@SuppressWarnings("serial")
public class CreateInstanceStep implements Step {

    private HostTemplate template;

    private EC2Adapter ec2Adapter;

    private String instanceName;

    public CreateInstanceStep(final HostTemplate template, EC2Adapter ec2Adapter, String instanceName) {
        this.template = template;
        this.instanceName = instanceName != null ? instanceName : "Created by XL Deploy @ " + (new Date()).toString();
        this.ec2Adapter = ec2Adapter;
    }

    @Override
    public int getOrder() {
        return DEFAULT_ORDER;
    }

    @Override
    public String getDescription() {
        return "Create EC2 instance " + instanceName + " at " + template.getRegion() + "/" + template.getAmi();
    }

    @Override
    public StepExitCode execute(final ExecutionContext context) throws Exception {
        try {
            context.logOutput("Making call to EC2 to start new instance...");

            String cloudId = ec2Adapter.kickNewInstance(
                    template,
                    instanceName,
                    template.getBootTimeout(),
                    template.getRetryDelay(),
                    template.getTags()
            );

            context.logOutput("New instance start has been triggered...");
            context.logOutput("Instance id: " + cloudId);

            ContextHelper.wrapped(context).safeSet(ContextAttribute.USED_TEMPLATES, new ArrayList<HostTemplate>(), asList(template));
            ContextHelper.wrapped(context).safeSet(ContextAttribute.CREATED_INSTANCES, new ArrayList<String>(), asList(cloudId));


            return StepExitCode.SUCCESS;
        } catch (IllegalArgumentException e) {
            context.logError("Can not create image template", e);
            return StepExitCode.FAIL;
        }
    }

}
