/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.Uris;
import org.jclouds.rest.InvocationContext;
import org.jclouds.util.Strings2;

public class ParseURIFromListOrLocationHeaderIf20x
implements Function<HttpResponse, URI>,
InvocationContext<ParseURIFromListOrLocationHeaderIf20x> {
    protected HttpRequest request;

    public URI apply(HttpResponse from) {
        if (from.getStatusCode() > 206) {
            throw new HttpException(String.format("Unhandled status code  - %1$s", from));
        }
        if ("text/uri-list".equals(from.getFirstHeaderOrNull("Content-Type"))) {
            try {
                if (from.getPayload().getInput() == null) {
                    throw new HttpResponseException("no content", null, from);
                }
                String toParse = Strings2.toString(from.getPayload());
                URI uRI = URI.create(toParse.trim());
                return uRI;
            }
            catch (IOException e) {
                throw new HttpResponseException("couldn't parse uri from content", null, from, (Throwable)e);
            }
            finally {
                HttpUtils.releasePayload(from);
            }
        }
        HttpUtils.releasePayload(from);
        String location = from.getFirstHeaderOrNull("Location");
        if (location == null) {
            location = from.getFirstHeaderOrNull("location");
        }
        if (location != null) {
            URI locationUri = URI.create(location);
            if (locationUri.getHost() != null) {
                return locationUri;
            }
            Preconditions.checkState((this.request != null ? 1 : 0) != 0, (Object)"request should have been initialized");
            if (!location.startsWith("/")) {
                location = "/" + location;
            }
            locationUri = URI.create(location);
            return Uris.uriBuilder(this.request.getEndpoint()).path(locationUri.getPath()).query(locationUri.getQuery()).build();
        }
        throw new HttpResponseException("no uri in headers or content", null, from);
    }

    @Override
    public ParseURIFromListOrLocationHeaderIf20x setContext(HttpRequest request) {
        this.request = request;
        return this;
    }
}

