/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.reflect;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.util.List;

@Beta
public final class Invocation {
    private final Invokable<?, ?> invokable;
    private final List<Object> args;

    public static Invocation create(Invokable<?, ?> invokable, List<Object> args) {
        return new Invocation(invokable, args);
    }

    public static Invocation create(Invokable<?, ?> invokable) {
        Preconditions.checkArgument((invokable.getParameters().size() == 0 || invokable.getParameters().size() == 1 && invokable.isVarArgs() ? 1 : 0) != 0, (String)"please specify arguments to %s", (Object[])new Object[]{invokable});
        return Invocation.create(invokable, (List<Object>)ImmutableList.of());
    }

    private Invocation(Invokable<?, ?> invokable, List<Object> args) {
        this.invokable = (Invokable)Preconditions.checkNotNull(invokable, (Object)"invokable");
        this.args = (List)Preconditions.checkNotNull(args, (Object)"args");
    }

    public Invokable<?, ?> getInvokable() {
        return this.invokable;
    }

    public List<Object> getArgs() {
        return this.args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invocation that = (Invocation)Invocation.class.cast(o);
        return Objects.equal(this.invokable, that.invokable) && Objects.equal(this.args, that.args);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.invokable, this.args});
    }

    public String toString() {
        return String.format("%s%s", this.invokable, this.args);
    }
}

