package com.xebialabs.deployit.plugin.ec2.util;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;

import com.xebialabs.deployit.plugin.ec2.access.EC2Adapter;
import com.xebialabs.deployit.plugin.ec2.ci.Credentials;
import org.slf4j.bridge.SLF4JBridgeHandler;

@SuppressWarnings("serial")
public class ServiceFactory implements Serializable {
    static {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.install();
        Logger.getLogger("global").setLevel(Level.FINEST);
    }

    public ComputeService getComputeService(String key, String secret) {
        ComputeServiceContext computeServiceContext = ContextBuilder.newBuilder("aws-ec2").
                credentials(key, secret).
                buildView(ComputeServiceContext.class);

        return computeServiceContext.getComputeService();
    }

    public EC2Adapter getEC2Adapter(Credentials credentials) {
        return new EC2Adapter(credentials);
    }
}
