/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.ec2.access;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.cloud.util.Retrier;
import com.xebialabs.deployit.plugin.ec2.ci.Credentials;
import com.xebialabs.deployit.plugin.ec2.ci.HostTemplate;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.jclouds.ContextBuilder;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.features.AWSInstanceApi;
import org.jclouds.aws.ec2.options.AWSRunInstancesOptions;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.ec2.features.TagApi;
import org.jclouds.ec2.options.RunInstancesOptions;

public class EC2Adapter
implements Serializable {
    protected Credentials credentials;
    private int actionTimeout = 20;
    private int retryDelay = 5;

    public EC2Adapter(Credentials credentials) {
        this.credentials = credentials;
    }

    public String kickNewInstance(HostTemplate nodeTemplate, String instanceLabel) throws TimeoutException {
        return this.kickNewInstance(nodeTemplate, instanceLabel, this.actionTimeout, this.retryDelay, Collections.emptyMap());
    }

    public String kickNewInstance(final HostTemplate nodeTemplate, String instanceLabel, int actionTimeout, int retryDelay, Map<String, String> tags) throws TimeoutException {
        final AWSEC2Api client = this.client(this.credentials);
        AWSRunInstancesOptions instanceOptions = AWSRunInstancesOptions.Builder.asType((String)nodeTemplate.getInstanceType().getValue()).withSecurityGroupIds(nodeTemplate.getGroups()).withKeyName(nodeTemplate.getKeyPair());
        if (!Strings.isNullOrEmpty((String)nodeTemplate.getVpcSubnetId())) {
            instanceOptions.withSubnetId(nodeTemplate.getVpcSubnetId());
        }
        if (!Strings.isNullOrEmpty((String)nodeTemplate.getIamInstanceProfileArn())) {
            instanceOptions.withIAMInstanceProfileArn(nodeTemplate.getIamInstanceProfileArn());
        }
        Reservation started = ((AWSInstanceApi)client.getInstanceApi().get()).runInstancesInRegion(nodeTemplate.getRegion(), null, nodeTemplate.getAmi(), 1, 1, new RunInstancesOptions[]{instanceOptions});
        final RunningInstance instance = (RunningInstance)Iterables.getOnlyElement((Iterable)started);
        final HashMap instanceTags = Maps.newHashMap((Map)((Map)Objects.firstNonNull(tags, (Object)Maps.newHashMap())));
        instanceTags.put("Name", instanceLabel);
        new Retrier((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                EC2Adapter.this.getTagApi(client, nodeTemplate).applyToResources(instanceTags, (Iterable)Lists.newArrayList((Object[])new String[]{instance.getId()}));
                return true;
            }
        }).retryFor(actionTimeout, retryDelay);
        return instance.getId();
    }

    public RunningInstance waitForRunningInstance(String region, String instanceId, int actionTimeout, int retryDelay) throws TimeoutException {
        AWSEC2Api client = this.client(this.credentials);
        return (RunningInstance)new Retrier((Callable)new Callable<RunningInstance>((EC2Api)client, region, instanceId){
            final /* synthetic */ EC2Api val$client;
            final /* synthetic */ String val$region;
            final /* synthetic */ String val$instanceId;
            {
                this.val$client = eC2Api;
                this.val$region = string;
                this.val$instanceId = string2;
            }

            @Override
            public RunningInstance call() throws Exception {
                RunningInstance instance = (RunningInstance)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)EC2Adapter.this.getInstanceApi(this.val$client).describeInstancesInRegion(this.val$region, new String[]{this.val$instanceId}))));
                if (InstanceState.RUNNING.equals((Object)instance.getInstanceState())) {
                    return instance;
                }
                throw new IllegalStateException("Expected state to be RUNNING, got " + instance.getInstanceState() + " instead");
            }
        }).retryFor(actionTimeout, retryDelay);
    }

    public String getPublicIpAddress(String region, String instanceId) {
        return ((AWSRunningInstance)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)((AWSInstanceApi)this.client(this.credentials).getInstanceApi().get()).describeInstancesInRegion(region, new String[]{instanceId}))))).getIpAddress();
    }

    public void shutDown(String region, String cloudId) {
        ((AWSInstanceApi)this.client(this.credentials).getInstanceApi().get()).terminateInstancesInRegion(region, new String[]{cloudId});
    }

    private AWSEC2Api client(Credentials credentials) {
        return (AWSEC2Api)ContextBuilder.newBuilder((String)"aws-ec2").credentials(credentials.getKey(), credentials.getSecret()).buildApi(AWSEC2Api.class);
    }

    private TagApi getTagApi(AWSEC2Api client, HostTemplate nodeTemplate) {
        Optional tagApiForRegionOptional = client.getTagApiForRegion(nodeTemplate.getRegion());
        if (tagApiForRegionOptional.isPresent()) {
            return (TagApi)tagApiForRegionOptional.get();
        }
        throw new IllegalStateException("Could not find getTagApiForRegion for " + EC2Api.class);
    }

    private InstanceApi getInstanceApi(EC2Api client) {
        Optional instanceApiOptional = client.getInstanceApi();
        if (instanceApiOptional.isPresent()) {
            return (InstanceApi)instanceApiOptional.get();
        }
        throw new IllegalStateException("Could not find getInstanceApi for " + EC2Api.class);
    }
}

