package com.xebialabs.deployit.plugin.cloud.util;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Map;

import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;

import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;

@SuppressWarnings("serial")
public class InstanceDescriptorResolver implements Serializable {

    private static final String TEMPLATE_NAME = "template";

    public String resolve(String templateString, Map<? extends Object, ? extends Object> model) throws TemplateException {
        Configuration configuration = new Configuration();

        StringTemplateLoader loader = new StringTemplateLoader();
        loader.putTemplate(TEMPLATE_NAME, templateString);

        configuration.setTemplateLoader(loader);
        configuration.setObjectWrapper(new CiAwareObjectWrapper());

        StringWriter processedXml = new StringWriter();

        try {
            configuration.getTemplate(TEMPLATE_NAME).process(model, processedXml);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        return processedXml.toString();
    }
}
