/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.ci;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.ConnectionType;
import com.xebialabs.deployit.plugin.cloud.step.ValidateHostDescriptorStep;
import com.xebialabs.deployit.plugin.cloud.util.CiParser;
import com.xebialabs.deployit.plugin.cloud.util.InstanceDescriptorResolver;
import com.xebialabs.deployit.plugin.cloud.validation.MarkerFileValidation;
import com.xebialabs.overthere.OperatingSystemFamily;
import freemarker.template.TemplateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

@Metadata(virtual=true, description="Base class for host templates, all host templates must extend it")
@MarkerFileValidation
public class BaseHostTemplate
extends BaseConfigurationItem {
    @Property(required=true, size=Property.Size.LARGE, label="Instance descriptor", description="Freemarker template of XML which describes instance and middleware")
    private String xmlDescriptor;
    @Property(required=false, category="Marker", label="OS family")
    private OperatingSystemFamily os;
    @Property(required=false, category="Marker", label="Connection type", description="Connection type to be used for connecting to the host")
    private ConnectionType connectionType;
    @Property(required=false, category="Marker", label="Username")
    private String username;
    @Property(required=false, category="Marker", label="Password", password=true)
    private String password;
    @Property(required=false, category="Marker", label="Private key file to use for authentication")
    private String privateKeyFile;
    @Property(required=false, category="Marker", label="Path to the marker file", description="Path to the file which should appear on the instance when provisioning completes.")
    private String markerPath;
    @Property(required=true, defaultValue="500", label="Boot timeout", description="Maximal amount of time (in seconds) allowed to elapse before the instance is ready.")
    private int bootTimeout;
    @Property(required=false, defaultValue="5", category="Marker", label="Retry delay", description="Delay (in seconds) after each connection attempt.")
    private int retryDelay;

    @ControlTask(label="Validate descriptor", description="Validate XML descriptor")
    public List<? extends Step> validateDescriptor() {
        return Lists.newArrayList((Object[])new ValidateHostDescriptorStep[]{new ValidateHostDescriptorStep(this.getXmlDescriptor(), this)});
    }

    public String getXmlDescriptor() {
        return this.xmlDescriptor;
    }

    public void setXmlDescriptor(String xmlDescriptor) {
        this.xmlDescriptor = xmlDescriptor;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public void setMarkerPath(String markerPath) {
        this.markerPath = markerPath;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public OperatingSystemFamily getOs() {
        return this.os;
    }

    public void setOs(OperatingSystemFamily os) {
        this.os = os;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getMarkerPath() {
        return this.markerPath;
    }

    public int getBootTimeout() {
        return this.bootTimeout;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    protected List<ConfigurationItem> produceInstanceCIs(Repository repository, Map<String, Object> scope) {
        try {
            String descriptor = new InstanceDescriptorResolver().resolve(this.getXmlDescriptor(), scope);
            return new CiParser().fromString(descriptor, repository);
        }
        catch (TemplateException e) {
            throw new RuntimeException("DescriptorResolver could not resolve " + this.getXmlDescriptor(), e);
        }
    }

    public List<ConfigurationItem> produceInstanceCIs(String cloudId, Repository repository, String hostsPath, String instancePublicAddress) throws TimeoutException {
        HashMap scope = Maps.newHashMap();
        scope.put("hostsPath", hostsPath);
        scope.put("hostTemplate", this);
        scope.put("cloudId", cloudId);
        scope.put("hostAddress", instancePublicAddress);
        return this.produceInstanceCIs(repository, scope);
    }
}

