/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.ci;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.cloud.ci.EnvironmentTemplate;
import com.xebialabs.deployit.plugin.cloud.ci.InstantiatableCloudTemplate;
import com.xebialabs.deployit.plugin.cloud.step.CheckEnvironmentStep;
import com.xebialabs.deployit.plugin.cloud.step.DeleteCloudEnvironmentStep;
import com.xebialabs.deployit.plugin.cloud.step.WipeEnvironmentStep;
import com.xebialabs.deployit.plugin.cloud.util.CiFilters;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Metadata(description="Cloud environment", root=Metadata.ConfigurationItemRoot.ENVIRONMENTS)
public class Environment
extends com.xebialabs.deployit.plugin.api.udm.Environment {
    @Property(required=true, label="Template", category="Cloud", description="Template which was used to create this environment")
    private EnvironmentTemplate template;
    @Property(required=true, label="Linked CIs", category="Cloud", description="CIs that were described in the template of this cloud environment and created along with it")
    private Set<ConfigurationItem> linkedCis = Sets.newHashSet();

    public Set<Container> getLinkedTopLevelContainers() {
        return Sets.filter(this.linkedCis, CiFilters.CloudContainers);
    }

    public EnvironmentTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(EnvironmentTemplate template) {
        this.template = template;
    }

    public Set<ConfigurationItem> getLinkedCis() {
        return this.linkedCis;
    }

    public void setLinkedCis(Set<ConfigurationItem> linkedCis) {
        this.linkedCis = linkedCis;
    }

    @ControlTask(label="Destroy", description="Shut down all related cloud instances and remove all related CIs")
    public List<? extends Step> destroy() {
        ArrayList steps = Lists.newArrayList((Object[])new Step[]{new CheckEnvironmentStep(this.getId()), new WipeEnvironmentStep(this)});
        for (ConfigurationItem configurationItem : this.getLinkedTopLevelContainers()) {
            InstantiatableCloudTemplate template = (InstantiatableCloudTemplate)configurationItem.getProperty("template");
            steps.addAll(template.produceDestroySteps(configurationItem));
        }
        steps.add(new DeleteCloudEnvironmentStep(this));
        return steps;
    }
}

