/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.ci;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.cloud.ci.BaseHostTemplate;
import com.xebialabs.deployit.plugin.cloud.ci.HostParameters;
import com.xebialabs.deployit.plugin.cloud.ci.InstantiatableCloudTemplate;
import com.xebialabs.deployit.plugin.cloud.step.RegisterInstancesStep;
import com.xebialabs.deployit.plugin.cloud.util.HostFactory;
import com.xebialabs.deployit.plugin.cloud.util.MarkerChecker;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.ConnectionOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

@Metadata(virtual=true, description="Base class for host instance templates, all independently instantiatable host instance templates must extend it")
public abstract class InstantiatableHostTemplate
extends BaseHostTemplate
implements InstantiatableCloudTemplate {
    private MarkerChecker markerChecker = new MarkerChecker();

    void setMarkerChecker(MarkerChecker markerChecker) {
        this.markerChecker = markerChecker;
    }

    @Override
    public List<? extends Step> produceValidationSteps() {
        return this.validateDescriptor();
    }

    @ControlTask(label="Instantiate", description="Create instance from template", parameterType="cloud.HostParameters")
    public List<? extends Step> instantiate(HostParameters params) {
        ArrayList steps = Lists.newArrayList((Iterable)this.produceCreateSteps(params.getInstanceName(), 0));
        steps.add(new RegisterInstancesStep(params.getHostsLocation()));
        return steps;
    }

    @Override
    public List<ConfigurationItem> produceInstanceCIs(String cloudId, Repository repository, String hostsPath) throws TimeoutException {
        String instancePublicAddress = this.getInstanceIpAddress(cloudId);
        return this.produceInstanceCIs(cloudId, repository, hostsPath, instancePublicAddress);
    }

    public abstract String getInstanceIpAddress(String var1) throws TimeoutException;

    @Override
    public void waitForAvailability(ExecutionContext ctx, String cloudId) throws TimeoutException {
        String instancePublicAddress = this.getInstanceIpAddress(cloudId);
        if (this.getMarkerPath() != null) {
            Host host = HostFactory.fromTemplate(this);
            host.setProperty("address", (Object)instancePublicAddress);
            ConnectionOptions connectionOptions = new Host.ConnectionOptionsBuilder().getConnectionOptions(host);
            this.markerChecker.waitForMarkerFileAppears((String)host.getProperty("protocol"), connectionOptions, this.getMarkerPath(), this.getBootTimeout(), this.getRetryDelay());
        }
    }
}

