/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import java.util.ArrayList;

public class CheckEnvironmentStep
implements Step {
    private static final String ENVIRONMENTS_ROOT = "Environments";
    private String environmentId;

    public CheckEnvironmentStep(String environmentId) {
        this.environmentId = environmentId;
    }

    public String getDescription() {
        return "Check if containers from " + this.environmentId + " are used in other environments and other way around";
    }

    public int getOrder() {
        return 50;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        com.xebialabs.deployit.plugin.cloud.ci.Environment targetEnv = (com.xebialabs.deployit.plugin.cloud.ci.Environment)((Object)Preconditions.checkNotNull((Object)ctx.getRepository().read(this.environmentId)));
        boolean errors = false;
        for (Container container : targetEnv.getMembers()) {
            if (this.belongsToOneOfTopLevelContainers(container, targetEnv)) continue;
            ctx.logOutput("Container " + container.getId() + " is used as a member of environment " + this.environmentId + " but was not created with it.");
            ctx.logOutput("Please remove the reference before destroying " + this.environmentId);
            errors = true;
        }
        ArrayList allEnvs = Lists.newArrayList();
        allEnvs.addAll(ctx.getRepository().search(Type.valueOf(Environment.class), ENVIRONMENTS_ROOT));
        allEnvs.addAll(ctx.getRepository().search(Type.valueOf(com.xebialabs.deployit.plugin.cloud.ci.Environment.class), ENVIRONMENTS_ROOT));
        for (ConfigurationItem configurationItem : targetEnv.getLinkedTopLevelContainers()) {
            for (Environment anEnv : allEnvs) {
                if (anEnv.equals((Object)targetEnv)) continue;
                for (Container container : anEnv.getMembers()) {
                    if (!container.getId().startsWith(configurationItem.getId())) continue;
                    ctx.logError("Environment " + anEnv.getId() + " contains " + container.getId() + " as a member.");
                    ctx.logError("Please remove this reference before " + targetEnv.getId() + " is destroyed.");
                    errors = true;
                }
            }
        }
        return errors ? StepExitCode.FAIL : StepExitCode.SUCCESS;
    }

    private boolean belongsToOneOfTopLevelContainers(final Container container, com.xebialabs.deployit.plugin.cloud.ci.Environment targetEnv) {
        System.out.println("container " + container.getId() + " targetEnv" + targetEnv.getId());
        return Collections2.filter(targetEnv.getLinkedTopLevelContainers(), (Predicate)new Predicate<Container>(){

            public boolean apply(Container input) {
                System.out.println("container " + container.getId() + " input " + input.getId());
                return container.equals(input) || container.getId().startsWith(input.getId() + "/");
            }
        }).size() == 1;
    }
}

