/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.step;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.EnvironmentTemplate;
import com.xebialabs.deployit.plugin.cloud.step.ContextAttribute;
import com.xebialabs.deployit.plugin.cloud.step.ValidateDescriptorStep;
import com.xebialabs.deployit.plugin.cloud.step.rule.SingleEnvCheck;
import com.xebialabs.deployit.plugin.cloud.util.ContextHelper;
import com.xebialabs.deployit.plugin.cloud.util.MapsHelper;
import freemarker.template.TemplateException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ValidateEnvironmentDescriptorStep
extends ValidateDescriptorStep {
    public static final Function<ConfigurationItem, String> CI_TO_ID = new Function<ConfigurationItem, String>(){

        public String apply(ConfigurationItem input) {
            return input.getId();
        }
    };

    public ValidateEnvironmentDescriptorStep(EnvironmentTemplate environmentTemplate, String ciName) {
        super(environmentTemplate.getXmlDescriptor(), ciName, new SingleEnvCheck());
        this.scope.put("environmentId", "Environments/exampleEnvironment");
        this.scope.put("hosts", Collections.emptyList());
        this.scope.put("containers", Collections.emptyList());
        this.scope.put("environmentTemplate", environmentTemplate);
    }

    @Override
    protected String resolveTemplate(String tpl, Map<Object, Object> initialScope, ExecutionContext ctx) throws TemplateException {
        List parsedCis = ContextHelper.wrapped(ctx).safeGet(ContextAttribute.PARSED_CIS, Collections.emptyList());
        Collection hostCis = Collections2.filter(parsedCis, (Predicate)new Predicate<ConfigurationItem>(){

            public boolean apply(ConfigurationItem input) {
                Type cloudSshHost = Type.valueOf((String)"cloud.SshHost");
                Type cloudCifsHost = Type.valueOf((String)"cloud.CifsHost");
                return input.getType().instanceOf(cloudSshHost) || input.getType().instanceOf(cloudCifsHost);
            }
        });
        Collection containerCis = Collections2.filter(parsedCis, (Predicate)new Predicate<ConfigurationItem>(){

            public boolean apply(ConfigurationItem input) {
                return input.getType().instanceOf(Type.valueOf((String)"udm.Container"));
            }
        });
        return this.descriptorResolver.resolve(tpl, MapsHelper.putOrMerge(MapsHelper.putOrMerge(initialScope, "hosts", hostCis), "containers", containerCis));
    }

    @Override
    protected List<ConfigurationItem> parseCis(String tpl, ExecutionContext ctx) {
        List parsedCis = ContextHelper.wrapped(ctx).safeGet(ContextAttribute.PARSED_CIS, Collections.emptyList());
        return this.ciParser.fromString(tpl, ctx.getRepository(), Sets.newHashSet((Iterable)Collections2.transform(parsedCis, CI_TO_ID)));
    }
}

