package com.xebialabs.deployit.plugin.cloud.ci;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Regex;

/**
 * Parameters which are needed to create dynamic env from template.
 */
@SuppressWarnings("serial")
@Metadata(description = "Parameters for cloud environment instantiation")
public class CloudEnvironmentParameters extends Parameters {

    @Property(required = true, defaultValue = "Environments", label = "Environment id", description = "Id of the environment you want to create")
    @Regex(pattern = "Environments/.+")
    private String environmentId;

    @Property(required = true, defaultValue = "Infrastructure", label = "Hosts location", description = "Repository location where all created hosts will appear")
    @Regex(pattern = "Infrastructure/?.*")
    private String hostsPath;

    public String getEnvironmentId() {
        return environmentId;
    }

    public String getHostsPath() {
        return hostsPath;
    }

    public void setEnvironmentId(final String environmentId) {
        this.environmentId = environmentId;
    }

    public void setHostsPath(final String hostsPath) {
        this.hostsPath = hostsPath;
    }
}