package com.xebialabs.deployit.plugin.cloud.step;

import java.util.List;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.cloud.ci.InstantiatableCloudTemplate;
import com.xebialabs.deployit.plugin.cloud.step.plan.Unique;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Step which waits for instances to become available based. Depends on {@link ContextAttribute#CREATED_INSTANCES} and
 * {@link ContextAttribute#USED_TEMPLATES} context attributes.
 */
@SuppressWarnings("serial")
@Unique
public class WaitForInstancesStep implements Step {

    public WaitForInstancesStep() {
    }

    @Override
    public int getOrder() {
        return DEFAULT_ORDER + 10;
    }

    @Override
    public String getDescription() {
        return "Wait until created instances become available";
    }

    @Override
    @SuppressWarnings("unchecked")
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {

        List<String> instances;
        List<InstantiatableCloudTemplate> templates;

        try {
            instances = checkNotNull((List<String>)ctx.getAttribute(ContextAttribute.CREATED_INSTANCES.toString()));
            templates = checkNotNull((List<InstantiatableCloudTemplate>) ctx.getAttribute(ContextAttribute.USED_TEMPLATES.toString()));
        } catch (NullPointerException e) {
            ctx.logError("Can not find required context attribute", e);
            return StepExitCode.FAIL;
        }

        for(int i=0; i < instances.size(); i++) {
            ctx.logOutput("Waiting until instance " + (i + 1) + " is available...");

            InstantiatableCloudTemplate cloudTpl = templates.get(i);
            cloudTpl.waitForAvailability(ctx, instances.get(i));
        }

        return StepExitCode.SUCCESS;
    }
}

