package com.xebialabs.deployit.plugin.cloud.util;

import java.util.Collection;
import java.util.Map;
import com.google.common.collect.ImmutableList;

import static com.google.common.collect.Iterables.concat;

public class MapsHelper {

    public static <S, K, V> Map<K, V> putOrMerge(Map<K, V> m, K key, Collection<S> value) {
        Collection<S> oldValue = (Collection<S>)m.get(key);
        if (oldValue != null) {
            ImmutableList<S> ses = ImmutableList.copyOf(concat(oldValue, value));
            m.put(key, (V)ses);
        } else {
            m.put(key, (V)value);
        }

        return m;
    }
}
