/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.step;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.Environment;
import com.xebialabs.deployit.plugin.cloud.ci.EnvironmentTemplate;
import com.xebialabs.deployit.plugin.cloud.step.ContextAttribute;
import com.xebialabs.deployit.plugin.cloud.step.rule.ResultCheck;
import com.xebialabs.deployit.plugin.cloud.step.rule.SingleEnvCheck;
import com.xebialabs.deployit.plugin.cloud.util.CiFilters;
import com.xebialabs.deployit.plugin.cloud.util.CiParser;
import com.xebialabs.deployit.plugin.cloud.util.ContextHelper;
import com.xebialabs.deployit.plugin.cloud.util.InstanceDescriptorResolver;
import freemarker.template.TemplateException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class RegisterEnvironmentStep
implements Step {
    private InstanceDescriptorResolver descriptorResolver;
    private CiParser ciParser;
    private EnvironmentTemplate environmentTemplate;
    private String environmentId;

    public RegisterEnvironmentStep(InstanceDescriptorResolver descriptorResolver, CiParser ciParser, EnvironmentTemplate environmentTemplate, String environmentId) {
        this.descriptorResolver = descriptorResolver;
        this.ciParser = ciParser;
        this.environmentTemplate = environmentTemplate;
        this.environmentId = environmentId;
    }

    public int getOrder() {
        return 100;
    }

    public String getDescription() {
        return "Register environment " + this.environmentId;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        List<ConfigurationItem> parsedCis;
        HashMap scope = Maps.newHashMap();
        Set containers = ContextHelper.wrapped(ctx).safeGet(ContextAttribute.REGISTERED_CONTAINERS.name(), Collections.emptySet());
        Set hosts = ContextHelper.wrapped(ctx).safeGet(ContextAttribute.REGISTERED_HOSTS.name(), Collections.emptySet());
        scope.put("environmentId", this.environmentId);
        scope.put("containers", containers);
        scope.put("hosts", hosts);
        scope.put("environmentTemplate", this.environmentTemplate);
        try {
            String descriptor = this.descriptorResolver.resolve(this.environmentTemplate.getXmlDescriptor(), scope);
            parsedCis = this.ciParser.fromString(descriptor, ctx.getRepository());
        }
        catch (TemplateException e) {
            ctx.logError(e.getMessage());
            return StepExitCode.FAIL;
        }
        try {
            new SingleEnvCheck().check(parsedCis);
        }
        catch (ResultCheck.Failed e) {
            ctx.logError(e.getMessage());
            return StepExitCode.FAIL;
        }
        Environment cloudEnvironment = (Environment)((Object)Collections2.filter(parsedCis, CiFilters.CloudEnvironments).iterator().next());
        Collection otherCis = Collections2.filter(parsedCis, (Predicate)Predicates.not(CiFilters.CloudEnvironments));
        Collection topLevelCloudContainers = Collections2.filter(containers, CiFilters.CloudContainers);
        cloudEnvironment.setLinkedCis((Set<ConfigurationItem>)Sets.union((Set)Sets.newHashSet((Iterable)otherCis), (Set)Sets.newHashSet((Iterable)topLevelCloudContainers)));
        cloudEnvironment.setTemplate(this.environmentTemplate);
        ctx.getRepository().create(parsedCis.toArray(new ConfigurationItem[parsedCis.size()]));
        return StepExitCode.SUCCESS;
    }
}

