/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.InstantiatableCloudTemplate;
import com.xebialabs.deployit.plugin.cloud.step.ContextAttribute;
import com.xebialabs.deployit.plugin.cloud.util.ContextHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class RegisterInstancesStep
implements Step {
    private final String hostsPath;

    public RegisterInstancesStep(String hostsPath) {
        this.hostsPath = hostsPath;
    }

    public int getOrder() {
        return 80;
    }

    public String getDescription() {
        return "Register created instances in repository";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        List templates;
        List instances;
        try {
            instances = (List)Preconditions.checkNotNull((Object)((List)ctx.getAttribute(ContextAttribute.CREATED_INSTANCES.name())));
            templates = (List)Preconditions.checkNotNull((Object)((List)ctx.getAttribute(ContextAttribute.USED_TEMPLATES.name())));
        }
        catch (NullPointerException e) {
            ctx.logError("Can not find required context attribute", (Throwable)e);
            return StepExitCode.FAIL;
        }
        for (int i = 0; i < instances.size(); ++i) {
            InstantiatableCloudTemplate instanceTpl = (InstantiatableCloudTemplate)templates.get(i);
            String cloudId = (String)instances.get(i);
            List<ConfigurationItem> cis = instanceTpl.produceInstanceCIs(cloudId, ctx.getRepository(), this.hostsPath);
            for (ConfigurationItem ci : cis) {
                ctx.logOutput("Configuration item " + ci.getId() + " has been created");
            }
            ctx.getRepository().create(cis.toArray(new ConfigurationItem[cis.size()]));
            Collection hosts = Collections2.filter(cis, (Predicate)new Predicate<ConfigurationItem>(){

                public boolean apply(ConfigurationItem ci) {
                    return ci.getType().getDescriptor().isAssignableTo(Type.valueOf((String)"overthere.Host"));
                }
            });
            Collection containers = Collections2.filter(cis, (Predicate)new Predicate<ConfigurationItem>(){

                public boolean apply(ConfigurationItem ci) {
                    return ci.getType().getDescriptor().isAssignableTo(Type.valueOf((String)"udm.Container"));
                }
            });
            for (ConfigurationItem host : hosts) {
                ctx.logOutput("Host " + host.getProperty("address") + " with underlying middleware is created");
            }
            ContextHelper.wrapped(ctx).safeSet(ContextAttribute.REGISTERED_CONTAINERS.name(), new HashSet(), containers);
            ContextHelper.wrapped(ctx).safeSet(ContextAttribute.REGISTERED_HOSTS.name(), new HashSet(), hosts);
        }
        return StepExitCode.SUCCESS;
    }
}

