/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.step;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.cloud.ci.InstantiatableCloudTemplate;
import com.xebialabs.deployit.plugin.cloud.step.ContextAttribute;
import com.xebialabs.deployit.plugin.cloud.step.plan.Unique;
import java.util.List;

@Unique
public class WaitForInstancesStep
implements Step {
    public int getOrder() {
        return 60;
    }

    public String getDescription() {
        return "Wait until created instances become available";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        List templates;
        List instances;
        try {
            instances = (List)Preconditions.checkNotNull((Object)((List)ctx.getAttribute(ContextAttribute.CREATED_INSTANCES.toString())));
            templates = (List)Preconditions.checkNotNull((Object)((List)ctx.getAttribute(ContextAttribute.USED_TEMPLATES.toString())));
        }
        catch (NullPointerException e) {
            ctx.logError("Can not find required context attribute", (Throwable)e);
            return StepExitCode.FAIL;
        }
        for (int i = 0; i < instances.size(); ++i) {
            ctx.logOutput("Waiting until instance " + (i + 1) + " is available...");
            InstantiatableCloudTemplate cloudTpl = (InstantiatableCloudTemplate)templates.get(i);
            cloudTpl.waitForAvailability(ctx, (String)instances.get(i));
        }
        return StepExitCode.SUCCESS;
    }
}

