/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.step;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.cloud.ci.Environment;
import java.util.Collection;
import java.util.List;

public class WipeEnvironmentStep
implements Step {
    private Environment environment;

    public WipeEnvironmentStep(Environment environment) {
        this.environment = environment;
    }

    public int getOrder() {
        return 90;
    }

    public String getDescription() {
        return "Remove all deployed applications from the environment " + this.environment.getId();
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        List apps = ctx.getRepository().search(Type.valueOf(DeployedApplication.class), this.environment.getId());
        if (!apps.isEmpty()) {
            for (ConfigurationItem app : apps) {
                ctx.logOutput("To be deleted: " + app);
            }
            String[] ids = Collections2.transform((Collection)apps, (Function)new Function<ConfigurationItem, String>(){

                public String apply(ConfigurationItem input) {
                    return input.toString();
                }
            }).toArray(new String[apps.size()]);
            ctx.getRepository().delete(ids);
        }
        return StepExitCode.SUCCESS;
    }
}

