/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.vsphere.ci;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.cloud.ci.BaseHostTemplate;
import com.xebialabs.deployit.plugin.cloud.vsphere.access.VsphereAdapter;
import com.xebialabs.deployit.plugin.cloud.vsphere.ci.Credentials;
import com.xebialabs.deployit.plugin.cloud.vsphere.steps.CreateVSphereInstanceStep;
import com.xebialabs.deployit.plugin.cloud.vsphere.steps.DestroyInstanceStep;
import com.xebialabs.deployit.plugin.cloud.vsphere.steps.WaitForVsphereIpsStep;
import com.xebialabs.deployit.plugin.cloud.vsphere.steps.WaitForVsphereTasksStep;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;

@Metadata(description="vSphere instance template", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class HostTemplate
extends BaseHostTemplate {
    @Property(required=true, label="vCenter credentials")
    private Credentials credentials;
    @Property(required=true, label="Datacenter", description="Name of the datacenter.")
    private String datacenter;
    @Property(required=true, label="Template path", description="Path to the template relative to the datacenter. The datacenter name should not be included in the path.")
    private String templatePath;
    @Property(required=true, label="Host", description="Name of the host or cluster on which to run the virtual machine.")
    private String host;
    @Property(required=false, label="Destination path", description="Path to the folder where the new virtual machine should be created, relative to the datacenter. Leave this field empty if you want to create the virtual machine directly under the datacenter.")
    private String destinationPath;
    @Property(required=false, label="Resource pool", description="Name of the resource pool to be used for the virtual machine.")
    private String resourcePool;
    @Property(required=false, label="Datastore", description="Name of the datastore to be used for the virtual machine.")
    private String datastore;
    @Property(required=false, label="Memory (MB)", description="Amount of memory to be allocated for the virtual machine in megabytes.")
    private int memory;
    @Property(required=false, label="CPUs", description="Amount of CPUs to be available for the virtual machine.")
    private int cpus;
    @Property(required=false, label="Customization specification", description="Name of the existing customization specification.")
    private String customization;

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public String getResourcePool() {
        return this.resourcePool;
    }

    public int getMemory() {
        return this.memory;
    }

    public int getCpus() {
        return this.cpus;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setDatacenter(String datacenter) {
        this.datacenter = datacenter;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public void setResourcePool(String resourcePool) {
        this.resourcePool = resourcePool;
    }

    public void setMemory(int memory) {
        this.memory = memory;
    }

    public void setCpus(int cpus) {
        this.cpus = cpus;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    public void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }

    public String getDatastore() {
        return this.datastore;
    }

    public void setDatastore(String datastore) {
        this.datastore = datastore;
    }

    public String getCustomization() {
        return this.customization;
    }

    public void setCustomization(String customization) {
        this.customization = customization;
    }

    public List<? extends Step> produceCreateSteps(String envName, int instanceSeq) {
        String instanceLabel = envName + " (" + this.getName() + ") #" + instanceSeq;
        VsphereAdapter adapter = new VsphereAdapter(this.getCredentials());
        return Arrays.asList(new CreateVSphereInstanceStep(this, instanceLabel, new VsphereAdapter(this.getCredentials())), new WaitForVsphereTasksStep(this, adapter), new WaitForVsphereIpsStep(this, adapter));
    }

    public List<? extends Step> produceDestroySteps(ConfigurationItem instance) {
        VsphereAdapter adapter = new VsphereAdapter(this.getCredentials());
        return Arrays.asList(new DestroyInstanceStep(instance, adapter), new WaitForVsphereTasksStep(this, adapter));
    }

    public String getInstanceIpAddress(String cloudId) throws TimeoutException {
        return new VsphereAdapter(this.getCredentials()).getIpAddress(cloudId);
    }
}

