/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.CloudEnvironmentParameters;

public class CheckParametersStep
implements Step {
    private final CloudEnvironmentParameters parameters;

    public CheckParametersStep(CloudEnvironmentParameters parameters) {
        this.parameters = parameters;
    }

    public int getOrder() {
        return 0;
    }

    public String getDescription() {
        return "Check if given parameters are valid";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        Repository repository = ctx.getRepository();
        if (repository.exists(this.parameters.getEnvironmentId())) {
            ctx.logError("CI with id [" + this.parameters.getEnvironmentId() + "] already exists. Please provide a non-existing id because the plugin will create it.");
            return StepExitCode.FAIL;
        }
        ctx.logOutput("Provided Environment id is OK.");
        if (!repository.exists(this.parameters.getHostsPath())) {
            ctx.logError("Infrastructure parent with id [" + this.parameters.getHostsPath() + "] does not exists. Please provide a valid parent or use the Infrastructure root node.");
            return StepExitCode.FAIL;
        }
        ConfigurationItem item = repository.read(this.parameters.getHostsPath());
        if (!item.getId().startsWith("Infrastructure") || !this.isRootNodeOrDirectory(item)) {
            ctx.logError("Infrastructure parent with id [" + this.parameters.getHostsPath() + "] is not the Infrastructure root node or a CI of type core.Directory.");
            return StepExitCode.FAIL;
        }
        ctx.logOutput("Provided Infrastructure parent id is OK.");
        return StepExitCode.SUCCESS;
    }

    private boolean isRootNodeOrDirectory(ConfigurationItem item) {
        return item.getType().instanceOf(Type.valueOf((String)"core.Directory")) || item.getId().indexOf(47) == -1;
    }
}

