/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.Environment;
import com.xebialabs.deployit.plugin.overthere.Host;

public class UnregisterInstanceStep
implements Step {
    private String instanceId;
    private String environmentId;

    public UnregisterInstanceStep(String instanceId) {
        this.instanceId = instanceId;
    }

    public UnregisterInstanceStep(String instanceId, String environmentId) {
        this.instanceId = instanceId;
        this.environmentId = environmentId;
    }

    public int getOrder() {
        return 80;
    }

    public String getDescription() {
        return "Delete " + this.instanceId + " from repository";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        Host instance = (Host)ctx.getRepository().read(this.instanceId);
        if (this.environmentId != null) {
            ctx.logOutput("Removing instance from environment " + this.environmentId);
            Environment environment = (Environment)ctx.getRepository().read(this.environmentId);
            environment.getLinkedCis().remove(instance);
            environment.getMembers().remove(instance);
            ctx.getRepository().update((ConfigurationItem[])new Environment[]{environment});
        }
        ctx.logOutput("Deleting instance " + this.instanceId);
        ctx.getRepository().delete(new String[]{this.instanceId});
        return StepExitCode.SUCCESS;
    }
}

