/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReference;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.xstream.CiXstreamReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CiParser
implements Serializable {
    public List<ConfigurationItem> fromString(String source, Repository repository) {
        return this.fromString(source, repository, (Set<String>)ImmutableSet.of());
    }

    public List<ConfigurationItem> fromString(String source, Repository repository, Set<String> externalReferences) {
        try {
            CiXstreamReader reader = new CiXstreamReader(new StaxDriver().createReader((InputStream)new ByteArrayInputStream(source.getBytes())));
            ConfigurationItemConverter converter = new ConfigurationItemConverter();
            List configurationItems = converter.readCis((CiListReader)reader);
            this.resolveReferencesSilently(repository, converter);
            block5: for (CiReference r : converter.getReferences()) {
                if (Sets.difference((Set)Sets.newHashSet((Iterable)r.getIds()), externalReferences).isEmpty()) continue;
                PropertyDescriptor pd = r.getProperty();
                switch (pd.getKind()) {
                    case LIST_OF_CI: 
                    case SET_OF_CI: {
                        ArrayList cis = Lists.newArrayList((Iterable)((Iterable)pd.get(r.getCi())));
                        if (cis.size() < r.getIds().size()) {
                            throw new ReferenceNotFoundException(r);
                        }
                        for (ConfigurationItem ci : cis) {
                            if (ci != null) continue;
                            throw new ReferenceNotFoundException(r);
                        }
                        continue block5;
                    }
                    default: {
                        if (pd.get(r.getCi()) != null) continue block5;
                        throw new ReferenceNotFoundException(r);
                    }
                }
            }
            return configurationItems;
        }
        catch (StreamException e) {
            throw new StreamException(e.getMessage().replaceAll("\\[row,col\\]\\:\\[([0-9]+),([0-9]+)\\]", "row: $1"));
        }
    }

    private void resolveReferencesSilently(Repository repository, ConfigurationItemConverter ciConverter) {
        for (CiReference reference : ciConverter.getReferences()) {
            ArrayList resolvedCIs = Lists.newArrayList();
            for (String id : reference.getIds()) {
                ConfigurationItem alsoRead = (ConfigurationItem)ciConverter.getReadCIs().get(id);
                if (alsoRead != null) {
                    resolvedCIs.add(alsoRead);
                    continue;
                }
                if (!repository.exists(id)) continue;
                resolvedCIs.add(repository.read(id));
            }
            reference.set((List)resolvedCIs);
        }
    }

    public class ReferenceNotFoundException
    extends RuntimeException {
        public ReferenceNotFoundException(CiReference r) {
            super("Can not find reference from {" + r.getCi().getId() + "}." + r.getProperty().getName() + " to " + Joiner.on((String)", ").join((Iterable)r.getIds()));
        }
    }
}

