/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.vsphere.steps;

import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.step.ContextAttribute;
import com.xebialabs.deployit.plugin.cloud.util.ContextHelper;
import com.xebialabs.deployit.plugin.cloud.vsphere.access.VsphereAdapter;
import com.xebialabs.deployit.plugin.cloud.vsphere.ci.HostTemplate;
import java.util.ArrayList;
import java.util.Arrays;

public class DestroyInstanceStep
implements Step {
    private String cloudId;
    private HostTemplate template;
    private VsphereAdapter adapter;

    public DestroyInstanceStep(ConfigurationItem instance, VsphereAdapter adapter) {
        this.cloudId = (String)instance.getProperty("cloudId");
        this.template = (HostTemplate)((Object)instance.getProperty("template"));
        this.adapter = adapter;
    }

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Destroy virtual machine " + this.cloudId;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        VirtualMachine vm = this.adapter.getVm(this.cloudId);
        Task powerOff = vm.powerOffVM_Task();
        Task destroy = vm.destroy_Task();
        ContextHelper.wrapped((ExecutionContext)ctx).safeSet((Enum)ContextAttribute.STARTED_TASKS, new ArrayList(), Arrays.asList(powerOff.getMOR().getVal(), destroy.getMOR().getVal()));
        return StepExitCode.SUCCESS;
    }
}

