/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.vsphere.steps;

import com.vmware.vim25.mo.ServiceInstance;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.cloud.vsphere.ci.Credentials;
import java.net.URL;

public class ValidateVSphereCredentialsStep
implements Step {
    private Credentials credentials;

    public ValidateVSphereCredentialsStep(Credentials credentials) {
        this.credentials = credentials;
    }

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Validate vSphere credentials for " + this.credentials.getUrl();
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput("Accessing " + this.credentials.getUrl());
        ServiceInstance si = new ServiceInstance(new URL(this.credentials.getUrl()), this.credentials.getUsername(), this.credentials.getPassword(), true);
        ctx.logOutput("OS type: " + si.getAboutInfo().getOsType());
        ctx.logOutput("API type: " + si.getAboutInfo().getApiType());
        ctx.logOutput("API version: " + si.getAboutInfo().getApiVersion());
        ctx.logOutput("Server time: " + si.getServerClock().getTime().toString());
        return StepExitCode.SUCCESS;
    }
}

