/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.dto.LoginProvider;
import com.xebialabs.deployit.spring.HoconPropertySourceFactory;
import com.xebialabs.platform.sso.oidc.authentication.CustomOidcIdTokenDecoderFactory;
import com.xebialabs.platform.sso.oidc.exceptions.UnsupportedOidcConfigurationException;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.GrantedAuthoritiesExtractor;
import com.xebialabs.platform.sso.oidc.service.XLOidcUserService;
import com.xebialabs.platform.sso.oidc.web.CustomAuthorizationRequestResolver;
import com.xebialabs.platform.sso.oidc.web.OidcLogoutSuccessHandler;
import com.xebialabs.xldeploy.authentication.oidc.conf.OidcConfig;
import com.xebialabs.xlplatform.config.ConfigLoader$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@EnableWebSecurity
@Configuration
@PropertySource(factory=HoconPropertySourceFactory.class, value={"classpath:xl-deploy.conf"})
@ScalaSignature(bytes="\u0006\u0005\tef\u0001\u0002\u000e\u001c\u0001!BQa\u000e\u0001\u0005\u0002aBQa\u000f\u0001\u0005\u0002qBQ!\u0014\u0001\u0005\u00029CQ\u0001\u0018\u0001\u0005\u00029CQA\u0018\u0001\u0005\u0002}CQ!\u001c\u0001\u0005\u00029DQ! \u0001\u0005\u0002yDq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0004bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003/\u0003A\u0011AAM\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!!1\u0001\t\u0003\t\u0019\rC\u0004\u0002T\u0002!\t!!6\t\u000f\u0005}\u0007\u0001\"\u0001\u0002b\"9\u0011q\u001e\u0001\u0005\u0002\u0005E\bbBA~\u0001\u0011%\u0011Q \u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u0011\u001d\u0011\t\u0002\u0001C\u0005\u0005'AqAa\t\u0001\t\u0013\u0011)\u0003C\u0004\u0003V\u0001!IAa\u0016\t\u000f\t\r\u0004\u0001\"\u0003\u0003f!9!1\u000f\u0001\u0005\n\tU$aE(qK:LEmQ8o]\u0016\u001cGoQ8oM&<'B\u0001\u000f\u001e\u0003\u0011\u0019wN\u001c4\u000b\u0005yy\u0012\u0001B8jI\u000eT!\u0001I\u0011\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^5p]*\u0011!eI\u0001\tq2$W\r\u001d7ps*\u0011A%J\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AJ\u0001\u0004G>l7\u0001A\n\u0004\u0001%z\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g\r\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005)1\u000f\u001c45U*\tA'\u0001\u0005he&T(\u0010\\3e\u0013\t1\u0014GA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005I\u0004C\u0001\u001e\u0001\u001b\u0005Y\u0012AC8jI\u000e\u001cuN\u001c4jOV\tQ\b\u0005\u0002;}%\u0011qh\u0007\u0002\u000b\u001f&$7mQ8oM&<\u0007F\u0001\u0002B!\t\u00115*D\u0001D\u0015\t!U)\u0001\u0006b]:|G/\u0019;j_:T!AR$\u0002\u000f\r|g\u000e^3yi*\u0011\u0001*S\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t!*A\u0002pe\u001eL!\u0001T\"\u0003\t\t+\u0017M\\\u0001\u0012_&$7\rT8hS:\u0004&o\u001c<jI\u0016\u0014X#A(\u0011\u0005AKV\"A)\u000b\u0005I\u001b\u0016a\u00013u_*\u0011A+V\u0001\u0004CBL'B\u0001,X\u0003\u0011\u0019wN]3\u000b\u0005a\u001b\u0013\u0001\u00033fa2|\u00170\u001b;\n\u0005i\u000b&!\u0004'pO&t\u0007K]8wS\u0012,'\u000f\u000b\u0002\u0004\u0003\u0006\u0011Bn\\2bY2{w-\u001b8Qe>4\u0018\u000eZ3sQ\t!\u0011)\u0001\u000fdY&,g\u000e\u001e*fO&\u001cHO]1uS>t'+\u001a9pg&$xN]=\u0016\u0003\u0001\u0004\"!\u00196\u000e\u0003\tT!a\u00193\u0002\u0019I,w-[:ue\u0006$\u0018n\u001c8\u000b\u0005\u00154\u0017AB2mS\u0016tGO\u0003\u0002hQ\u00061q.Y;uQJR!![$\u0002\u0011M,7-\u001e:jifL!a\u001b2\u0003I%sW*Z7pef\u001cE.[3oiJ+w-[:ue\u0006$\u0018n\u001c8SKB|7/\u001b;pefD#!B!\u0002A\rd\u0017-[7t)><%/\u00198uK\u0012\fU\u000f\u001e5pe&$\u0018.Z:Q_2L7-_\u000b\u0002_B\u0011\u0001O_\u0007\u0002c*\u0011!o]\u0001\u0005S6\u0004HN\u0003\u0002uk\u00061\u0001o\u001c7jGfT!A\b<\u000b\u0005]D\u0018aA:t_*\u0011\u0011pI\u0001\ta2\fGOZ8s[&\u001110\u001d\u0002(\t\u00164\u0017-\u001e7u\u00072\f\u0017.\\:U_\u001e\u0013\u0018M\u001c;fI\u0006+H\u000f[8sSRLWm\u001d)pY&\u001c\u0017\u0010\u000b\u0002\u0007\u0003\u0006\u00113-^:u_6\fU\u000f\u001e5pe&T\u0018\r^5p]J+\u0017/^3tiJ+7o\u001c7wKJ$2a`A\u0006!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003k\u0006\u0019q/\u001a2\n\t\u0005%\u00111\u0001\u0002#\u0007V\u001cHo\\7BkRDwN]5{CRLwN\u001c*fcV,7\u000f\u001e*fg>dg/\u001a:\t\ry;\u0001\u0019AA\u0007!\r\t\u0017qB\u0005\u0004\u0003#\u0011'\u0001H\"mS\u0016tGOU3hSN$(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\u0015\u0004\u000f\u0005U\u0001\u0003BA\f\u0003Gi!!!\u0007\u000b\u0007\u0011\u000bYB\u0003\u0003\u0002\u001e\u0005}\u0011a\u00024bGR|'/\u001f\u0006\u0004\u0003C9\u0015!\u00022fC:\u001c\u0018\u0002BA\u0013\u00033\u0011\u0011\"Q;u_^L'/\u001a3)\u0005\u001d\t\u0015aF1vi\"|'/\u001b>fI\u000ec\u0017.\u001a8u'\u0016\u0014h/[2f)\u0011\ti#!\u000e\u0011\t\u0005=\u0012\u0011G\u0007\u0002I&\u0019\u00111\u00073\u0003K%sW*Z7pef|\u0015)\u001e;ie\u0005+H\u000f[8sSj,Gm\u00117jK:$8+\u001a:wS\u000e,\u0007B\u00020\t\u0001\u0004\ti\u0001K\u0002\t\u0003+A#\u0001C!\u0002#adw*\u001b3d+N,'oU3sm&\u001cW\r\u0006\u0003\u0002@\u0005-\u0003\u0003BA!\u0003\u000fj!!a\u0011\u000b\u0007\u0005\u0015S/A\u0004tKJ4\u0018nY3\n\t\u0005%\u00131\t\u0002\u001212{\u0015\u000eZ2Vg\u0016\u00148+\u001a:wS\u000e,\u0007BB7\n\u0001\u0004\ti\u0005\u0005\u0003\u0002P\u0005ES\"A:\n\u0007\u0005M3O\u0001\u0011DY\u0006LWn\u001d+p\u000fJ\fg\u000e^3e\u0003V$\bn\u001c:ji&,7\u000fU8mS\u000eL\bfA\u0005\u0002\u0016!\u0012\u0011\"Q\u0001\u001bCV$\bn\u001c:ju\u0016$7\t\\5f]R\u0014V\r]8tSR|'/\u001f\u000b\u0005\u0003;\n9\u0007\u0005\u0003\u0002`\u0005\rTBAA1\u0015\r\t)\u0001Z\u0005\u0005\u0003K\n\tG\u0001\u001cBkRDWM\u001c;jG\u0006$X\r\u001a)sS:\u001c\u0017\u000e]1m\u001f\u0006+H\u000f\u001b\u001aBkRDwN]5{K\u0012\u001cE.[3oiJ+\u0007o\\:ji>\u0014\u0018\u0010C\u0004\u0002*)\u0001\r!!\u001b\u0011\t\u0005=\u00121N\u0005\u0004\u0003[\"'!H(BkRD''Q;uQ>\u0014\u0018N_3e\u00072LWM\u001c;TKJ4\u0018nY3)\u0007)\t)\u0002\u000b\u0002\u000b\u0003\u0006)\u0012\u000e\u001a+pW\u0016tG)Z2pI\u0016\u0014h)Y2u_JLXCAA<!\u0019\tI(a \u0002\u00046\u0011\u00111\u0010\u0006\u0004\u0003{2\u0017a\u00016xi&!\u0011\u0011QA>\u0005EQu\u000f\u001e#fG>$WM\u001d$bGR|'/\u001f\t\u0004C\u0006\u0015\u0015bAADE\n\u00112\t\\5f]R\u0014VmZ5tiJ\fG/[8oQ\tY\u0011)\u0001\u0006koR$UmY8eKJ,\"!a$\u0011\t\u0005e\u0014\u0011S\u0005\u0005\u0003'\u000bYH\u0001\u0006KoR$UmY8eKJD#\u0001D!\u00025)<H/Q;uQ\u0016tG/[2bi&|gnQ8om\u0016\u0014H/\u001a:\u0016\u0005\u0005m\u0005\u0003BAO\u0003Sk!!a(\u000b\u0007\u0001\n\tK\u0003\u0003\u0002$\u0006\u0015\u0016\u0001\u0003:fg>,(oY3\u000b\u0007\u0005\u001df-\u0001\u0004tKJ4XM]\u0005\u0005\u0003W\u000byJ\u0001\u000eKoR\fU\u000f\u001e5f]RL7-\u0019;j_:\u001cuN\u001c<feR,'\u000f\u000b\u0002\u000e\u0003\u0006!\u0013-\u001e;i_JL'0\u0019;j_:\u001cu\u000eZ3U_.,gNU3ta>t7/Z\"mS\u0016tG/\u0006\u0002\u00024B!\u0011QWA^\u001b\t\t9LC\u0002\u0002:\u0012\f\u0001\"\u001a8ea>Lg\u000e^\u0005\u0005\u0003{\u000b9LA\u0016EK\u001a\fW\u000f\u001c;BkRDwN]5{CRLwN\\\"pI\u0016$vn[3o%\u0016\u001c\bo\u001c8tK\u000ec\u0017.\u001a8uQ\tq\u0011)A\fpS\u0012\u001cGj\\4j]\u001a\u000b\u0017\u000e\\;sK\"\u000bg\u000e\u001a7feV\u0011\u0011Q\u0019\t\u0005\u0003\u000f\fi-\u0004\u0002\u0002J*\u0019\u0001%a3\u000b\u0007\u0005\u0015\u0001.\u0003\u0003\u0002P\u0006%'\u0001H!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a%b]\u0012dWM\u001d\u0015\u0003\u001f\u0005\u000ba\u0003\u001f7e\u0019><\u0017N\u001c$bS2,(/\u001a%b]\u0012dWM]\u000b\u0003\u0003/\u0004B!a2\u0002Z&!\u00111\\Ae\u0005\u0015\u001a\u0016.\u001c9mKV\u0013H.Q;uQ\u0016tG/[2bi&|gNR1jYV\u0014X\rS1oI2,'\u000f\u000b\u0002\u0011\u0003\u0006Qr\u000e]3o\u0013\u0012dunZ8viN+8mY3tg\"\u000bg\u000e\u001a7feR!\u00111]Au!\u0011\t\t!!:\n\t\u0005\u001d\u00181\u0001\u0002\u0019\u001f&$7\rT8h_V$8+^2dKN\u001c\b*\u00198eY\u0016\u0014\bB\u00020\u0012\u0001\u0004\ti\u0001K\u0002\u0012\u0003+A#!E!\u0002A1|w-\u001b8Ve2\fU\u000f\u001e5f]RL7-\u0019;j_:,e\u000e\u001e:z!>Lg\u000e^\u000b\u0003\u0003g\u0004B!a2\u0002v&!\u0011q_Ae\u0005\u0001bunZ5o+Jd\u0017)\u001e;iK:$\u0018nY1uS>tWI\u001c;ssB{\u0017N\u001c;)\u0005I\t\u0015AE2mS\u0016tGOU3hSN$(/\u0019;j_:,\"!a!\u00029\u001d,Go\u00117jK:$(+Z4jgR\u0014\u0018\r^5p]\n+\u0018\u000e\u001c3feV\u0011!1\u0001\t\u0005\u0005\u000b\u0011YAD\u0002b\u0005\u000fI1A!\u0003c\u0003I\u0019E.[3oiJ+w-[:ue\u0006$\u0018n\u001c8\n\t\t5!q\u0002\u0002\b\u0005VLG\u000eZ3s\u0015\r\u0011IAY\u0001\u0019G2LWM\u001c;IiR\u0004(+Z9vKN$h)Y2u_JLXC\u0001B\u000b!\u0011\u00119Ba\b\u000e\u0005\te!bA3\u0003\u001c)\u0019!QD$\u0002\t!$H\u000f]\u0005\u0005\u0005C\u0011IB\u0001\rDY&,g\u000e\u001e%uiB\u0014V-];fgR4\u0015m\u0019;pef\fqbZ3u\u0015^\u001c\u0018\t\\4pe&$\b.\u001c\u000b\u0007\u0005O\u00119D!\u0015\u0011\t\t%\"1G\u0007\u0003\u0005WQAA!\f\u00030\u0005\u0019!n^:\u000b\u0007\tEb-\u0001\u0003k_N,\u0017\u0002\u0002B\u001b\u0005W\u0011ABS<t\u00032<wN]5uQ6DqA!\u000f\u0017\u0001\u0004\u0011Y$\u0001\u0007koN\fEnZ8sSRDW\u000e\u0005\u0003\u0003>\t-c\u0002\u0002B \u0005\u000f\u00022A!\u0011,\u001b\t\u0011\u0019EC\u0002\u0003F\u001d\na\u0001\u0010:p_Rt\u0014b\u0001B%W\u00051\u0001K]3eK\u001aLAA!\u0014\u0003P\t11\u000b\u001e:j]\u001eT1A!\u0013,\u0011\u001d\u0011\u0019F\u0006a\u0001\u0005w\tA\u0002\u001d:pa\u0016\u0014H/\u001f(b[\u0016\f1cZ3u\u00072LWM\u001c;BkRDW*\u001a;i_\u0012,\"A!\u0017\u0011\t\tm#qL\u0007\u0003\u0005;R!A\u00164\n\t\t\u0005$Q\f\u0002\u001b\u00072LWM\u001c;BkRDWM\u001c;jG\u0006$\u0018n\u001c8NKRDw\u000eZ\u0001\u001bO\u0016$(j\u001e;P\u0003V$\bN\r+pW\u0016tg+\u00197jI\u0006$xN]\u000b\u0003\u0005O\u0002bAa\u0017\u0003j\t5\u0014\u0002\u0002B6\u0005;\u0012AcT!vi\"\u0014Dk\\6f]Z\u000bG.\u001b3bi>\u0014\b\u0003BA=\u0005_JAA!\u001d\u0002|\t\u0019!j\u001e;\u00023Y\fG.\u001b3bi\u0016|\u0015\u000eZ2D_:4\u0017nZ;sCRLwN\u001c\u000b\u0003\u0005o\u00022A\u000bB=\u0013\r\u0011Yh\u000b\u0002\u0005+:LG\u000fK\u0006\u0001\u0005\u007f\niB!\"\u0003\u0014\nU\u0005c\u0001\"\u0003\u0002&\u0019!1Q\"\u0003\u001dA\u0013x\u000e]3sif\u001cv.\u001e:dK\u000e\u0012!q\u0011\t\u0005\u0005\u0013\u0013y)\u0004\u0002\u0003\f*\u0019!QR,\u0002\rM\u0004(/\u001b8h\u0013\u0011\u0011\tJa#\u00035!{7m\u001c8Qe>\u0004XM\u001d;z'>,(oY3GC\u000e$xN]=\u0002\u000bY\fG.^3-\u0005\t]\u0015E\u0001BM\u0003a\u0019G.Y:ta\u0006$\bN\u000f=m[\u0011,\u0007\u000f\\8z]\r|gN\u001a\u0015\u0004\u0001\tu\u0005c\u0001\"\u0003 &\u0019!\u0011U\"\u0003\u001b\r{gNZ5hkJ\fG/[8oQ\r\u0001!Q\u0015\t\u0005\u0005O\u0013),\u0004\u0002\u0003**!!1\u0016BW\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]*!\u0011Q\u0001BX\u0015\r!%\u0011\u0017\u0006\u0004\u0005gC\u0017AB2p]\u001aLw-\u0003\u0003\u00038\n%&!E#oC\ndWmV3c'\u0016\u001cWO]5us\u0002")
public class OpenIdConnectConfig
implements Logging {
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        OpenIdConnectConfig openIdConnectConfig = this;
        synchronized (openIdConnectConfig) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Bean
    public OidcConfig oidcConfig() {
        return new OidcConfig(ConfigLoader$.MODULE$.loadWithDynamic("xl-deploy.conf"));
    }

    @Bean
    public LoginProvider oidcLoginProvider() {
        return new LoginProvider(this.oidcConfig().loginMethodDescription(), new StringBuilder(1).append(".").append(this.oidcConfig().external_login()).toString(), "./logout", false);
    }

    @Bean
    public LoginProvider localLoginProvider() {
        return new LoginProvider("XL Deploy local login", "./login", "./logout", true);
    }

    @Bean
    public InMemoryClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.clientRegistration()});
    }

    @Bean
    public DefaultClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.oidcConfig().rolesClaimName());
    }

    @Bean
    @Autowired
    public CustomAuthorizationRequestResolver customAuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        return new CustomAuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
    }

    @Bean
    @Autowired
    public InMemoryOAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    @Autowired
    public XLOidcUserService xlOidcUserService(ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        return new XLOidcUserService(claimsToGrantedAuthoritiesPolicy);
    }

    @Bean
    @Autowired
    public AuthenticatedPrincipalOAuth2AuthorizedClientRepository authorizedClientRepository(OAuth2AuthorizedClientService authorizedClientService) {
        return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        void var3_3;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(this.clientHttpRequestFactory());
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().idTokenJWSAlg(), "idTokenJWSAlg");
        CustomOidcIdTokenDecoderFactory idTokenDecoderFactory = new CustomOidcIdTokenDecoderFactory();
        idTokenDecoderFactory.setJwsAlgorithmResolver(x$1 -> jwsAlgorithm);
        idTokenDecoderFactory.setRestOperations((RestOperations)restTemplate);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtDecoder jwtDecoder() {
        void var3_9;
        NimbusJwtDecoder nimbusJwtDecoder;
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().accessTokenJWSAlg(), "jwsAlg");
        JwsAlgorithm jwsAlgorithm2 = jwsAlgorithm;
        if (jwsAlgorithm2 instanceof SignatureAlgorithm) {
            SignatureAlgorithm signatureAlgorithm = (SignatureAlgorithm)jwsAlgorithm2;
            String jwkSetUri = Strings.isNotBlank((String)this.oidcConfig().accessTokenKeyUri()) ? this.oidcConfig().accessTokenKeyUri() : this.clientRegistration().getProviderDetails().getJwkSetUri();
            nimbusJwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(signatureAlgorithm).build();
        } else if (jwsAlgorithm2 instanceof MacAlgorithm) {
            MacAlgorithm macAlgorithm = (MacAlgorithm)jwsAlgorithm2;
            scala.collection.immutable.Map mappings = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MacAlgorithm.HS256), (Object)"HmacSHA256"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MacAlgorithm.HS384), (Object)"HmacSHA384"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MacAlgorithm.HS512), (Object)"HmacSHA512")}));
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenSecretKey()), (String)"No configuration setting found for key 'xl.security.auth.providers.oidc.access-token.secretKey'", (Object[])new Object[0]);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.oidcConfig().accessTokenSecretKey().getBytes(StandardCharsets.UTF_8), (String)mappings.get((Object)macAlgorithm));
            nimbusJwtDecoder = NimbusJwtDecoder.withSecretKey((SecretKey)secretKeySpec).macAlgorithm(macAlgorithm).build();
        } else {
            throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
        }
        NimbusJwtDecoder jwtDecoder = nimbusJwtDecoder;
        jwtDecoder.setJwtValidator(this.getJwtOAuth2TokenValidator());
        return var3_9;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtAuthenticationConverter jwtAuthenticationConverter() {
        void var1_1;
        JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
        jwtAuthenticationConverter.setPrincipalClaimName(this.oidcConfig().userNameClaimName());
        jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)new GrantedAuthoritiesExtractor((ClaimsToGrantedAuthoritiesPolicy)this.claimsToGrantedAuthoritiesPolicy()));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient() {
        void var3_3;
        ListBuffer messageConverter = new ListBuffer();
        messageConverter.$plus$eq((Object)new FormHttpMessageConverter());
        messageConverter.$plus$eq((Object)new OAuth2AccessTokenResponseHttpMessageConverter());
        RestTemplate restTemplate = new RestTemplate(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)messageConverter.toList()).asJava());
        restTemplate.setRequestFactory(this.clientHttpRequestFactory());
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
        authorizationCodeTokenResponseClient.setRestOperations((RestOperations)restTemplate);
        return var3_3;
    }

    @Bean
    public AuthenticationFailureHandler oidcLoginFailureHandler() {
        return (x$2, response, x$3) -> response.sendRedirect(this.oidcConfig().external_login());
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler xldLoginFailureHandler() {
        return new SimpleUrlAuthenticationFailureHandler();
    }

    @Bean
    @Autowired
    public OidcLogoutSuccessHandler openIdLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        return new OidcLogoutSuccessHandler(clientRegistrationRepository, this.oidcConfig().postLogoutRedirectUri(), "/login");
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(this.oidcConfig().external_login());
    }

    private ClientRegistration clientRegistration() {
        ClientRegistration.Builder clientRegistrationBuilder = this.getClientRegistrationBuilder();
        clientRegistrationBuilder.clientId(this.oidcConfig().clientId()).clientSecret(this.oidcConfig().clientSecret()).clientAuthenticationMethod(this.getClientAuthMethod()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUriTemplate(this.oidcConfig().redirectUri()).userInfoUri("").scope(this.oidcConfig().scopes()).userNameAttributeName(this.oidcConfig().userNameClaimName());
        Object object = Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()) ? clientRegistrationBuilder.authorizationUri(this.oidcConfig().userAuthorizationUri()) : BoxedUnit.UNIT;
        Object object2 = Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()) ? clientRegistrationBuilder.tokenUri(this.oidcConfig().accessTokenUri()) : BoxedUnit.UNIT;
        Object object3 = Strings.isNotBlank((String)this.oidcConfig().jwks_uri()) ? clientRegistrationBuilder.jwkSetUri(this.oidcConfig().jwks_uri()) : BoxedUnit.UNIT;
        ClientRegistration clientRegistration = clientRegistrationBuilder.build();
        Map configurationMetadata = clientRegistration.getProviderDetails().getConfigurationMetadata();
        HashMap<String, String> updatedConfigurationMetadata = new HashMap<String, String>(configurationMetadata);
        updatedConfigurationMetadata.put("rolesClaim", this.oidcConfig().rolesClaimName());
        Object object4 = Strings.isNotBlank((String)this.oidcConfig().logoutUri()) ? updatedConfigurationMetadata.put("end_session_endpoint", this.oidcConfig().logoutUri()) : BoxedUnit.UNIT;
        return ClientRegistration.withClientRegistration((ClientRegistration)clientRegistration).providerConfigurationMetadata(updatedConfigurationMetadata).build();
    }

    private ClientRegistration.Builder getClientRegistrationBuilder() {
        ClientRegistration.Builder builder;
        try {
            if (!this.oidcConfig().issuer().matches("\\S+")) {
                throw new UnsupportedOidcConfigurationException(new StringBuilder(148).append("Whitespace characters in issuer url [").append(this.oidcConfig().issuer()).append("] is not supported. Recommendation is to avoid using spaces in URLs, and instead use hyphens to separate words.").toString());
            }
            builder = ClientRegistrations.fromOidcIssuerLocation((String)this.oidcConfig().issuer()).registrationId(this.oidcConfig().registrationId());
        }
        catch (RuntimeException re) {
            RuntimeException runtimeException = re;
            if (runtimeException instanceof IllegalArgumentException) {
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(62).append("Unable to resolve Configuration with the provided Issuer of [").append(this.oidcConfig().issuer()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (runtimeException instanceof UnsupportedOidcConfigurationException) {
                this.logger().warn((Function0 & Serializable)() -> re.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)runtimeException);
            }
            this.validateOidcConfiguration();
            builder = ClientRegistration.withRegistrationId((String)this.oidcConfig().registrationId());
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private ClientHttpRequestFactory clientHttpRequestFactory() {
        void var1_1;
        block0: {
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            if (!Strings.isNotEmpty((String)this.oidcConfig().proxyHost())) break block0;
            requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.oidcConfig().proxyHost(), Predef$.MODULE$.Integer2int(this.oidcConfig().proxyPort()))));
        }
        return var1_1;
    }

    private JwsAlgorithm getJwsAlgorithm(String jwsAlgorithm, String propertyName) {
        scala.collection.immutable.Map jwsAlgorithms = (scala.collection.immutable.Map)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])SignatureAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])MacAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return (JwsAlgorithm)jwsAlgorithms.getOrElse((Object)jwsAlgorithm, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(77).append(propertyName).append(" value [").append(jwsAlgorithm).append("] is not supported. Ensure you have configured a valid JWS Algorithm.").toString());
        });
    }

    private ClientAuthenticationMethod getClientAuthMethod() {
        scala.collection.immutable.Map clientAuthMethods = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_basic"), (Object)ClientAuthenticationMethod.BASIC), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_post"), (Object)ClientAuthenticationMethod.POST)}));
        return (ClientAuthenticationMethod)clientAuthMethods.getOrElse((Object)this.oidcConfig().clientAuthMethod().toLowerCase(), (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(108).append("clientAuthMethod value [").append(this.oidcConfig().clientAuthMethod()).append(" is not supported. Ensure you have configured a valid client authentication method.]").toString());
        });
    }

    private OAuth2TokenValidator<Jwt> getJwtOAuth2TokenValidator() {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(new JwtIssuerValidator(Strings.isNotBlank((String)this.oidcConfig().accessTokenIssuer()) ? this.oidcConfig().accessTokenIssuer() : this.oidcConfig().issuer()));
        validators.add(new JwtClaimValidator("aud", aud -> aud.contains(Strings.isNotBlank((String)this.oidcConfig().accessTokenAudience()) ? this.oidcConfig().accessTokenAudience() : this.oidcConfig().clientId())));
        return new DelegatingOAuth2TokenValidator(validators);
    }

    private void validateOidcConfiguration() {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()), (String)OpenIdConnectConfig.getErrorMessage$1("xl.security.auth.providers.oidc.userAuthorizationUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()), (String)OpenIdConnectConfig.getErrorMessage$1("xl.security.auth.providers.oidc.accessTokenUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().jwks_uri()), (String)OpenIdConnectConfig.getErrorMessage$1("xl.security.auth.providers.oidc.keyRetrievalUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().logoutUri()), (String)OpenIdConnectConfig.getErrorMessage$1("xl.security.auth.providers.oidc.logoutUri"), (Object[])new Object[0]);
    }

    private static final String getErrorMessage$1(String placeholder) {
        return new StringBuilder(41).append("No configuration setting found for key '").append(placeholder).append("'").toString();
    }

    public OpenIdConnectConfig() {
        Logging.$init$((Logging)this);
    }
}

