/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.web.util.UriComponentsBuilder;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001\u0002\u001c8\u0001\u0011C\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\u0006'\u0002!\t\u0001\u0016\u0005\b1\u0002\u0011\r\u0011\"\u0001Z\u0011\u0019)\u0007\u0001)A\u00055\"9a\r\u0001b\u0001\n\u0003I\u0006BB4\u0001A\u0003%!\fC\u0004i\u0001\t\u0007I\u0011A-\t\r%\u0004\u0001\u0015!\u0003[\u0011\u001dQ\u0007A1A\u0005\u0002eCaa\u001b\u0001!\u0002\u0013Q\u0006b\u00027\u0001\u0005\u0004%\t!\u0017\u0005\u0007[\u0002\u0001\u000b\u0011\u0002.\t\u000f9\u0004!\u0019!C\u00013\"1q\u000e\u0001Q\u0001\niCq\u0001\u001d\u0001C\u0002\u0013\u0005\u0011\f\u0003\u0004r\u0001\u0001\u0006IA\u0017\u0005\be\u0002\u0011\r\u0011\"\u0001Z\u0011\u0019\u0019\b\u0001)A\u00055\"9A\u000f\u0001b\u0001\n\u0003I\u0006BB;\u0001A\u0003%!\fC\u0004w\u0001\t\u0007I\u0011A-\t\r]\u0004\u0001\u0015!\u0003[\u0011\u001dA\bA1A\u0005\u0002eCa!\u001f\u0001!\u0002\u0013Q\u0006b\u0002>\u0001\u0005\u0004%\t!\u0017\u0005\u0007w\u0002\u0001\u000b\u0011\u0002.\t\u000fq\u0004!\u0019!C\u00013\"1Q\u0010\u0001Q\u0001\niCqA \u0001C\u0002\u0013\u0005\u0011\f\u0003\u0004\u0000\u0001\u0001\u0006IA\u0017\u0005\t\u0003\u0003\u0001!\u0019!C\u00013\"9\u00111\u0001\u0001!\u0002\u0013Q\u0006\u0002CA\u0003\u0001\t\u0007I\u0011A-\t\u000f\u0005\u001d\u0001\u0001)A\u00055\"A\u0011\u0011\u0002\u0001C\u0002\u0013\u0005\u0011\fC\u0004\u0002\f\u0001\u0001\u000b\u0011\u0002.\t\u0011\u00055\u0001A1A\u0005\u0002eCq!a\u0004\u0001A\u0003%!\f\u0003\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0001Z\u0011\u001d\t\u0019\u0002\u0001Q\u0001\niC\u0001\"!\u0006\u0001\u0005\u0004%\t!\u0017\u0005\b\u0003/\u0001\u0001\u0015!\u0003[\u0011!\tI\u0002\u0001b\u0001\n\u0003I\u0006bBA\u000e\u0001\u0001\u0006IA\u0017\u0005\t\u0003;\u0001!\u0019!C\u00013\"9\u0011q\u0004\u0001!\u0002\u0013Q\u0006\"CA\u0011\u0001\u0001\u0007I\u0011AA\u0012\u0011%\t)\u0004\u0001a\u0001\n\u0003\t9\u0004\u0003\u0005\u0002D\u0001\u0001\u000b\u0015BA\u0013\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000fBq!a\u0015\u0001\t\u0013\t)\u0006C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h\tQq*\u001b3d\u0007>tg-[4\u000b\u0005aJ\u0014\u0001B2p]\u001aT!AO\u001e\u0002\t=LGm\u0019\u0006\u0003yu\na\"Y;uQ\u0016tG/[2bi&|gN\u0003\u0002?\u007f\u0005A\u0001\u0010\u001c3fa2|\u0017P\u0003\u0002A\u0003\u0006I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0005\u0006\u00191m\\7\u0004\u0001M\u0011\u0001!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0002\u0011\u0006)1oY1mC&\u0011!j\u0012\u0002\u0007\u0003:L(+\u001a4\u0002\r\r|gNZ5h!\ti\u0015+D\u0001O\u0015\tYuJ\u0003\u0002Q\u0003\u0006AA/\u001f9fg\u00064W-\u0003\u0002S\u001d\n11i\u001c8gS\u001e\fa\u0001P5oSRtDCA+X!\t1\u0006!D\u00018\u0011\u0015Y%\u00011\u0001M\u00039\u0011XmZ5tiJ\fG/[8o\u0013\u0012,\u0012A\u0017\t\u00037\nt!\u0001\u00181\u0011\u0005u;U\"\u00010\u000b\u0005}\u001b\u0015A\u0002\u001fs_>$h(\u0003\u0002b\u000f\u00061\u0001K]3eK\u001aL!a\u00193\u0003\rM#(/\u001b8h\u0015\t\tw)A\bsK\u001eL7\u000f\u001e:bi&|g.\u00133!\u0003!\u0019G.[3oi&#\u0017!C2mS\u0016tG/\u00133!\u00031\u0019G.[3oiN+7M]3u\u00035\u0019G.[3oiN+7M]3uA\u0005\u00012\r\\5f]R\fU\u000f\u001e5NKRDw\u000eZ\u0001\u0012G2LWM\u001c;BkRDW*\u001a;i_\u0012\u0004\u0013AB5tgV,'/A\u0004jgN,XM\u001d\u0011\u0002\u0011)<8n]0ve&\f\u0011B[<lg~+(/\u001b\u0011\u0002\u001d\u0005\u001c7-Z:t)>\\WM\\+sS\u0006y\u0011mY2fgN$vn[3o+JL\u0007%\u0001\u000bvg\u0016\u0014\u0018)\u001e;i_JL'0\u0019;j_:,&/[\u0001\u0016kN,'/Q;uQ>\u0014\u0018N_1uS>tWK]5!\u0003%awnZ8viV\u0013\u0018.\u0001\u0006m_\u001e|W\u000f^+sS\u0002\n1B]3eSJ,7\r^+sS\u0006a!/\u001a3je\u0016\u001cG/\u0016:jA\u0005)\u0002o\\:u\u0019><w.\u001e;SK\u0012L'/Z2u+JL\u0017A\u00069pgRdunZ8viJ+G-\u001b:fGR,&/\u001b\u0011\u0002\u001dI|G.Z:DY\u0006LWNT1nK\u0006y!o\u001c7fg\u000ec\u0017-[7OC6,\u0007%A\tvg\u0016\u0014h*Y7f\u00072\f\u0017.\u001c(b[\u0016\f!#^:fe:\u000bW.Z\"mC&lg*Y7fA\u0005i\u0011\u000e\u001a+pW\u0016t'jV*BY\u001e\fa\"\u001b3U_.,gNS,T\u00032<\u0007%A\tbG\u000e,7o\u001d+pW\u0016t\u0017j]:vKJ\f!#Y2dKN\u001cHk\\6f]&\u001b8/^3sA\u0005\u0019\u0012mY2fgN$vn[3o\u0003V$\u0017.\u001a8dK\u0006!\u0012mY2fgN$vn[3o\u0003V$\u0017.\u001a8dK\u0002\n\u0011#Y2dKN\u001cHk\\6f].+\u00170\u0016:j\u0003I\t7mY3tgR{7.\u001a8LKf,&/\u001b\u0011\u0002#\u0005\u001c7-Z:t)>\\WM\u001c&X'\u0006cw-\u0001\nbG\u000e,7o\u001d+pW\u0016t'jV*BY\u001e\u0004\u0013\u0001F1dG\u0016\u001c8\u000fV8lK:\u001cVm\u0019:fi.+\u00170A\u000bbG\u000e,7o\u001d+pW\u0016t7+Z2sKR\\U-\u001f\u0011\u0002\u001d\u0015DH/\u001a:oC2|Fn\\4j]\u0006yQ\r\u001f;fe:\fGn\u00187pO&t\u0007%\u0001\fm_\u001eLg.T3uQ>$G)Z:de&\u0004H/[8o\u0003]awnZ5o\u001b\u0016$\bn\u001c3EKN\u001c'/\u001b9uS>t\u0007%A\u0005qe>D\u0018\u0010S8ti\u0006Q\u0001O]8ys\"{7\u000f\u001e\u0011\u0002\u0013A\u0014x\u000e_=Q_J$XCAA\u0013!\u0011\t9#!\r\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\tA\u0001\\1oO*\u0011\u0011qF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00024\u0005%\"aB%oi\u0016<WM]\u0001\u000eaJ|\u00070\u001f)peR|F%Z9\u0015\t\u0005e\u0012q\b\t\u0004\r\u0006m\u0012bAA\u001f\u000f\n!QK\\5u\u0011%\t\t\u0005MA\u0001\u0002\u0004\t)#A\u0002yIE\n!\u0002\u001d:pqf\u0004vN\u001d;!\u0003E9W\r^*ue&tw\r\u0015:pa\u0016\u0014H/\u001f\u000b\b5\u0006%\u00131JA(\u0011\u0015Y%\u00071\u0001M\u0011\u0019\tiE\ra\u00015\u0006!a.Y7f\u0011\u0019\t\tF\ra\u00015\u0006aA-\u001a4bk2$h+\u00197vK\u0006qq-\u001a;J]R\u0004&o\u001c9feRLH\u0003CA\u0013\u0003/\nI&a\u0017\t\u000b-\u001b\u0004\u0019\u0001'\t\r\u000553\u00071\u0001[\u0011\u001d\t\tf\ra\u0001\u0003K\t1cZ3u\u000b:\u001cw\u000eZ3e+JL7\u000b\u001e:j]\u001e$2AWA1\u0011\u0019\t\u0019\u0007\u000ea\u00015\u0006\u0019QO]5\u0002'\u001d,G\u000fR3d_\u0012,G-\u0016:j'R\u0014\u0018N\\4\u0015\t\u0005%\u0014Q\u000e\t\u0005\u0003O\tY'C\u0002d\u0003SAa!a\u00196\u0001\u0004Q\u0006")
public class OidcConfig {
    private final String registrationId;
    private final String clientId;
    private final String clientSecret;
    private final String clientAuthMethod;
    private final String issuer;
    private final String jwks_uri;
    private final String accessTokenUri;
    private final String userAuthorizationUri;
    private final String logoutUri;
    private final String redirectUri;
    private final String postLogoutRedirectUri;
    private final String rolesClaimName;
    private final String userNameClaimName;
    private final String idTokenJWSAlg;
    private final String accessTokenIssuer;
    private final String accessTokenAudience;
    private final String accessTokenKeyUri;
    private final String accessTokenJWSAlg;
    private final String accessTokenSecretKey;
    private final String external_login;
    private final String loginMethodDescription;
    private final String proxyHost;
    private Integer proxyPort;

    public String registrationId() {
        return this.registrationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String clientAuthMethod() {
        return this.clientAuthMethod;
    }

    public String issuer() {
        return this.issuer;
    }

    public String jwks_uri() {
        return this.jwks_uri;
    }

    public String accessTokenUri() {
        return this.accessTokenUri;
    }

    public String userAuthorizationUri() {
        return this.userAuthorizationUri;
    }

    public String logoutUri() {
        return this.logoutUri;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public String postLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public String rolesClaimName() {
        return this.rolesClaimName;
    }

    public String userNameClaimName() {
        return this.userNameClaimName;
    }

    public String idTokenJWSAlg() {
        return this.idTokenJWSAlg;
    }

    public String accessTokenIssuer() {
        return this.accessTokenIssuer;
    }

    public String accessTokenAudience() {
        return this.accessTokenAudience;
    }

    public String accessTokenKeyUri() {
        return this.accessTokenKeyUri;
    }

    public String accessTokenJWSAlg() {
        return this.accessTokenJWSAlg;
    }

    public String accessTokenSecretKey() {
        return this.accessTokenSecretKey;
    }

    public String external_login() {
        return this.external_login;
    }

    public String loginMethodDescription() {
        return this.loginMethodDescription;
    }

    public String proxyHost() {
        return this.proxyHost;
    }

    public Integer proxyPort() {
        return this.proxyPort;
    }

    public void proxyPort_$eq(Integer x$1) {
        this.proxyPort = x$1;
    }

    private String getStringProperty(Config config, String name, String defaultValue) {
        String string;
        try {
            string = config.getString(name);
        }
        catch (ConfigException.Missing missing) {
            string = defaultValue;
        }
        return string;
    }

    private Integer getIntProperty(Config config, String name, Integer defaultValue) {
        Integer n;
        try {
            n = Predef$.MODULE$.int2Integer(config.getInt(name));
        }
        catch (ConfigException.Missing missing) {
            n = defaultValue;
        }
        return n;
    }

    private String getEncodedUriString(String uri) {
        String string;
        try {
            string = URI.create(uri).toASCIIString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = UriComponentsBuilder.fromUriString((String)uri).build().toUri().toASCIIString();
        }
        return string;
    }

    private String getDecodedUriString(String uri) {
        String string;
        try {
            string = URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(String.format("Cannot decode value [%s] with 'utf-8' charset", uri));
        }
        return string;
    }

    public OidcConfig(Config config) {
        this.registrationId = "xl-deploy";
        this.clientId = config.getString("xl.security.auth.providers.oidc.clientId");
        this.clientSecret = config.getString("xl.security.auth.providers.oidc.clientSecret");
        this.clientAuthMethod = this.getStringProperty(config, "xl.security.auth.providers.oidc.clientAuthMethod", "client_secret_post");
        this.issuer = this.getDecodedUriString(config.getString("xl.security.auth.providers.oidc.issuer"));
        this.jwks_uri = this.getEncodedUriString(this.getStringProperty(config, "xl.security.auth.providers.oidc.keyRetrievalUri", ""));
        this.accessTokenUri = this.getDecodedUriString(this.getStringProperty(config, "xl.security.auth.providers.oidc.accessTokenUri", ""));
        this.userAuthorizationUri = this.getEncodedUriString(this.getStringProperty(config, "xl.security.auth.providers.oidc.userAuthorizationUri", ""));
        this.logoutUri = this.getDecodedUriString(this.getStringProperty(config, "xl.security.auth.providers.oidc.logoutUri", ""));
        this.redirectUri = this.getEncodedUriString(config.getString("xl.security.auth.providers.oidc.redirectUri"));
        this.postLogoutRedirectUri = this.getStringProperty(config, "xl.security.auth.providers.oidc.postLogoutRedirectUri", this.redirectUri());
        this.rolesClaimName = config.getString("xl.security.auth.providers.oidc.rolesClaimName");
        this.userNameClaimName = config.getString("xl.security.auth.providers.oidc.userNameClaimName");
        this.idTokenJWSAlg = this.getStringProperty(config, "xl.security.auth.providers.oidc.idTokenJWSAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenIssuer = this.getStringProperty(config, "xl.security.auth.providers.oidc.access-token.issuer", "");
        this.accessTokenAudience = this.getStringProperty(config, "xl.security.auth.providers.oidc.access-token.audience", "");
        this.accessTokenKeyUri = this.getStringProperty(config, "xl.security.auth.providers.oidc.access-token.keyRetrievalUri", "");
        this.accessTokenJWSAlg = this.getStringProperty(config, "xl.security.auth.providers.oidc.access-token.jwsAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenSecretKey = this.getStringProperty(config, "xl.security.auth.providers.oidc.access-token.secretKey", "");
        this.external_login = new StringBuilder(22).append("/oauth2/authorization").append("/").append(this.registrationId()).toString();
        this.loginMethodDescription = this.getStringProperty(config, "xl.security.auth.providers.oidc.loginMethodDescription", "External login (OpenID Connect)");
        this.proxyHost = this.getStringProperty(config, "xl.security.auth.providers.oidc.proxyHost", null);
        this.proxyPort = this.getIntProperty(config, "xl.security.auth.providers.oidc.proxyPort", null);
    }
}

