/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.dto.LoginProvider;
import com.xebialabs.platform.sso.oidc.authentication.CustomOidcIdTokenDecoderFactory;
import com.xebialabs.platform.sso.oidc.exceptions.UnsupportedOidcConfigurationException;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.GrantedAuthoritiesExtractor;
import com.xebialabs.platform.sso.oidc.service.XLOidcUserService;
import com.xebialabs.platform.sso.oidc.web.CustomAuthorizationRequestResolver;
import com.xebialabs.platform.sso.oidc.web.OidcLogoutSuccessHandler;
import com.xebialabs.xldeploy.authentication.oidc.conf.OidcConfig;
import com.xebialabs.xlplatform.config.ConfigLoader$;
import com.xebialabs.xlplatform.config.ConfigurationHolder$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ConditionalOnProperty(name={"deploy.server.security.auth.provider"}, havingValue="oidc")
@EnableWebSecurity
@Configuration
@ComponentScan(value={"com.xebialabs.xldeploy.auth.oidc.config"})
@ScalaSignature(bytes="\u0006\u0005\t]g\u0001B\u000e\u001d\u0001%BQ\u0001\u000f\u0001\u0005\u0002eBQ\u0001\u0010\u0001\u0005\u0002uBQA\u0014\u0001\u0005\u0002=CQ!\u0018\u0001\u0005\u0002=CQa\u0018\u0001\u0005\u0002\u0001DQA\u001c\u0001\u0005\u0002=DQA \u0001\u0005\u0002}Dq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBAG\u0001\u0011\u0005\u0011q\u0012\u0005\b\u00033\u0003A\u0011AAN\u0011\u001d\t\t\f\u0001C\u0001\u0003gCq!a1\u0001\t\u0003\t)\rC\u0004\u0002V\u0002!\t!a6\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002d\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005M\bbBA\u007f\u0001\u0011%\u0011q \u0005\b\u0005\u0003\u0001A\u0011\u0002B\u0002\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqA!\n\u0001\t\u0013\u00119\u0003C\u0004\u0003X\u0001!IA!\u0017\t\u000f\t\u0015\u0004\u0001\"\u0003\u0003h!9!Q\u000f\u0001\u0005\n\t]\u0004b\u0002B@\u0001\u0011\u0005!\u0011\u0011\u0002\u0014\u001fB,g.\u00133D_:tWm\u0019;D_:4\u0017n\u001a\u0006\u0003;y\tAaY8oM*\u0011q\u0004I\u0001\u0005_&$7M\u0003\u0002\"E\u0005q\u0011-\u001e;iK:$\u0018nY1uS>t'BA\u0012%\u0003!AH\u000eZ3qY>L(BA\u0013'\u0003%AXMY5bY\u0006\u00147OC\u0001(\u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0006\r\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014!B:mMRR'\"A\u001b\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\u000e\u001a\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\u000f\t\u0003w\u0001i\u0011\u0001H\u0001\u000b_&$7mQ8oM&<W#\u0001 \u0011\u0005mz\u0014B\u0001!\u001d\u0005)y\u0015\u000eZ2D_:4\u0017n\u001a\u0015\u0003\u0005\t\u0003\"a\u0011'\u000e\u0003\u0011S!!\u0012$\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002H\u0011\u000691m\u001c8uKb$(BA%K\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A&\u0002\u0007=\u0014x-\u0003\u0002N\t\n!!)Z1o\u0003Ey\u0017\u000eZ2M_\u001eLg\u000e\u0015:pm&$WM]\u000b\u0002!B\u0011\u0011KW\u0007\u0002%*\u00111\u000bV\u0001\u0004IR|'BA+W\u0003\r\t\u0007/\u001b\u0006\u0003/b\u000bAaY8sK*\u0011\u0011\fJ\u0001\tI\u0016\u0004Hn\\=ji&\u00111L\u0015\u0002\u000e\u0019><\u0017N\u001c)s_ZLG-\u001a:)\u0005\r\u0011\u0015A\u00057pG\u0006dGj\\4j]B\u0013xN^5eKJD#\u0001\u0002\"\u00029\rd\u0017.\u001a8u%\u0016<\u0017n\u001d;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ssV\t\u0011\r\u0005\u0002cW6\t1M\u0003\u0002eK\u0006a!/Z4jgR\u0014\u0018\r^5p]*\u0011amZ\u0001\u0007G2LWM\u001c;\u000b\u0005!L\u0017AB8bkRD'G\u0003\u0002k\u0011\u0006A1/Z2ve&$\u00180\u0003\u0002mG\n!\u0013J\\'f[>\u0014\u0018p\u00117jK:$(+Z4jgR\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u000b\u0002\u0006\u0005\u0006\u00013\r\\1j[N$vn\u0012:b]R,G-Q;uQ>\u0014\u0018\u000e^5fgB{G.[2z+\u0005\u0001\bCA9|\u001b\u0005\u0011(BA:u\u0003\u0011IW\u000e\u001d7\u000b\u0005U4\u0018A\u00029pY&\u001c\u0017P\u0003\u0002 o*\u0011\u00010_\u0001\u0004gN|'B\u0001>%\u0003!\u0001H.\u0019;g_Jl\u0017B\u0001?s\u0005\u001d\"UMZ1vYR\u001cE.Y5ngR{wI]1oi\u0016$\u0017)\u001e;i_JLG/[3t!>d\u0017nY=)\u0005\u0019\u0011\u0015AI2vgR|W.Q;uQ>\u0014\u0018N_1uS>t'+Z9vKN$(+Z:pYZ,'\u000f\u0006\u0003\u0002\u0002\u00055\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001da/A\u0002xK\nLA!a\u0003\u0002\u0006\t\u00113)^:u_6\fU\u000f\u001e5pe&T\u0018\r^5p]J+\u0017/^3tiJ+7o\u001c7wKJDaaX\u0004A\u0002\u0005=\u0001c\u00012\u0002\u0012%\u0019\u00111C2\u00039\rc\u0017.\u001a8u%\u0016<\u0017n\u001d;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\"\u001aq!a\u0006\u0011\t\u0005e\u0011QE\u0007\u0003\u00037Q1!RA\u000f\u0015\u0011\ty\"!\t\u0002\u000f\u0019\f7\r^8ss*\u0019\u00111\u0005%\u0002\u000b\t,\u0017M\\:\n\t\u0005\u001d\u00121\u0004\u0002\n\u0003V$xn^5sK\u0012D#a\u0002\"\u0002/\u0005,H\u000f[8sSj,Gm\u00117jK:$8+\u001a:wS\u000e,G\u0003BA\u0018\u0003o\u0001B!!\r\u000245\tQ-C\u0002\u00026\u0015\u0014Q%\u00138NK6|'/_(BkRD''Q;uQ>\u0014\u0018N_3e\u00072LWM\u001c;TKJ4\u0018nY3\t\r}C\u0001\u0019AA\bQ\rA\u0011q\u0003\u0015\u0003\u0011\t\u000b\u0011\u0003\u001f7PS\u0012\u001cWk]3s'\u0016\u0014h/[2f)\u0011\t\t%!\u0014\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012w\u0003\u001d\u0019XM\u001d<jG\u0016LA!a\u0013\u0002F\t\t\u0002\fT(jI\u000e,6/\u001a:TKJ4\u0018nY3\t\r9L\u0001\u0019AA(!\u0011\t\t&a\u0015\u000e\u0003QL1!!\u0016u\u0005\u0001\u001aE.Y5ngR{wI]1oi\u0016$\u0017)\u001e;i_JLG/[3t!>d\u0017nY=)\u0007%\t9\u0002\u000b\u0002\n\u0005\u0006Q\u0012-\u001e;i_JL'0\u001a3DY&,g\u000e\u001e*fa>\u001c\u0018\u000e^8ssR!\u0011qLA5!\u0011\t\t'!\u001a\u000e\u0005\u0005\r$bAA\u0004K&!\u0011qMA2\u0005Y\nU\u000f\u001e5f]RL7-\u0019;fIB\u0013\u0018N\\2ja\u0006dw*Q;uQJ\nU\u000f\u001e5pe&TX\rZ\"mS\u0016tGOU3q_NLGo\u001c:z\u0011\u001d\tYC\u0003a\u0001\u0003W\u0002B!!\r\u0002n%\u0019\u0011qN3\u0003;=\u000bU\u000f\u001e53\u0003V$\bn\u001c:ju\u0016$7\t\\5f]R\u001cVM\u001d<jG\u0016D3ACA\fQ\tQ!)A\u000bjIR{7.\u001a8EK\u000e|G-\u001a:GC\u000e$xN]=\u0016\u0005\u0005e\u0004CBA>\u0003\u0003\u000b))\u0004\u0002\u0002~)\u0019\u0011qP4\u0002\u0007)<H/\u0003\u0003\u0002\u0004\u0006u$!\u0005&xi\u0012+7m\u001c3fe\u001a\u000b7\r^8ssB\u0019!-a\"\n\u0007\u0005%5M\u0001\nDY&,g\u000e\u001e*fO&\u001cHO]1uS>t\u0007FA\u0006C\u0003)Qw\u000f\u001e#fG>$WM]\u000b\u0003\u0003#\u0003B!a\u001f\u0002\u0014&!\u0011QSA?\u0005)Qu\u000f\u001e#fG>$WM\u001d\u0015\u0003\u0019\t\u000b!D[<u\u0003V$\b.\u001a8uS\u000e\fG/[8o\u0007>tg/\u001a:uKJ,\"!!(\u0011\t\u0005}\u00151V\u0007\u0003\u0003CS1!IAR\u0015\u0011\t)+a*\u0002\u0011I,7o\\;sG\u0016T1!!+h\u0003\u0019\u0019XM\u001d<fe&!\u0011QVAQ\u0005iQu\u000f^!vi\",g\u000e^5dCRLwN\\\"p]Z,'\u000f^3sQ\ti!)\u0001\u0013bkRDwN]5{CRLwN\\\"pI\u0016$vn[3o%\u0016\u001c\bo\u001c8tK\u000ec\u0017.\u001a8u+\t\t)\f\u0005\u0003\u00028\u0006uVBAA]\u0015\r\tY,Z\u0001\tK:$\u0007o\\5oi&!\u0011qXA]\u0005-\"UMZ1vYR\fU\u000f\u001e5pe&T\u0018\r^5p]\u000e{G-\u001a+pW\u0016t'+Z:q_:\u001cXm\u00117jK:$\bF\u0001\bC\u0003]y\u0017\u000eZ2M_\u001eLgNR1jYV\u0014X\rS1oI2,'/\u0006\u0002\u0002HB!\u0011\u0011ZAh\u001b\t\tYMC\u0002\"\u0003\u001bT1!a\u0002j\u0013\u0011\t\t.a3\u00039\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sK\"\u000bg\u000e\u001a7fe\"\u0012qBQ\u0001\u0017q2$Gj\\4j]\u001a\u000b\u0017\u000e\\;sK\"\u000bg\u000e\u001a7feV\u0011\u0011\u0011\u001c\t\u0005\u0003\u0013\fY.\u0003\u0003\u0002^\u0006-'!J*j[BdW-\u0016:m\u0003V$\b.\u001a8uS\u000e\fG/[8o\r\u0006LG.\u001e:f\u0011\u0006tG\r\\3sQ\t\u0001\")\u0001\u000epa\u0016t\u0017\n\u001a'pO>,HoU;dG\u0016\u001c8\u000fS1oI2,'\u000f\u0006\u0003\u0002f\u0006-\b\u0003BA\u0002\u0003OLA!!;\u0002\u0006\tAr*\u001b3d\u0019><w.\u001e;Tk\u000e\u001cWm]:IC:$G.\u001a:\t\r}\u000b\u0002\u0019AA\bQ\r\t\u0012q\u0003\u0015\u0003#\t\u000b\u0001\u0005\\8hS:,&\u000f\\!vi\",g\u000e^5dCRLwN\\#oiJL\bk\\5oiV\u0011\u0011Q\u001f\t\u0005\u0003\u0013\f90\u0003\u0003\u0002z\u0006-'\u0001\t'pO&tWK\u001d7BkRDWM\u001c;jG\u0006$\u0018n\u001c8F]R\u0014\u0018\u0010U8j]RD#A\u0005\"\u0002%\rd\u0017.\u001a8u%\u0016<\u0017n\u001d;sCRLwN\\\u000b\u0003\u0003\u000b\u000bAdZ3u\u00072LWM\u001c;SK\u001eL7\u000f\u001e:bi&|gNQ;jY\u0012,'/\u0006\u0002\u0003\u0006A!!q\u0001B\u0007\u001d\r\u0011'\u0011B\u0005\u0004\u0005\u0017\u0019\u0017AE\"mS\u0016tGOU3hSN$(/\u0019;j_:LAAa\u0004\u0003\u0012\t9!)^5mI\u0016\u0014(b\u0001B\u0006G\u0006A2\r\\5f]RDE\u000f\u001e9SKF,Xm\u001d;GC\u000e$xN]=\u0016\u0005\t]\u0001\u0003\u0002B\r\u0005Ci!Aa\u0007\u000b\u0007\u0019\u0014iBC\u0002\u0003 !\u000bA\u0001\u001b;ua&!!1\u0005B\u000e\u0005a\u0019E.[3oi\"#H\u000f\u001d*fcV,7\u000f\u001e$bGR|'/_\u0001\u0010O\u0016$(j^:BY\u001e|'/\u001b;i[R1!\u0011\u0006B\u001d\u0005'\u0002BAa\u000b\u000365\u0011!Q\u0006\u0006\u0005\u0005_\u0011\t$A\u0002koNT1Aa\rh\u0003\u0011Qwn]3\n\t\t]\"Q\u0006\u0002\r\u0015^\u001c\u0018\t\\4pe&$\b.\u001c\u0005\b\u0005w1\u0002\u0019\u0001B\u001f\u00031Qwo]!mO>\u0014\u0018\u000e\u001e5n!\u0011\u0011yD!\u0014\u000f\t\t\u0005#\u0011\n\t\u0004\u0005\u0007bSB\u0001B#\u0015\r\u00119\u0005K\u0001\u0007yI|w\u000e\u001e \n\u0007\t-C&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u001f\u0012\tF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005\u0017b\u0003b\u0002B+-\u0001\u0007!QH\u0001\raJ|\u0007/\u001a:us:\u000bW.Z\u0001\u0014O\u0016$8\t\\5f]R\fU\u000f\u001e5NKRDw\u000eZ\u000b\u0003\u00057\u0002BA!\u0018\u0003b5\u0011!q\f\u0006\u0003/\u001eLAAa\u0019\u0003`\tQ2\t\\5f]R\fU\u000f\u001e5f]RL7-\u0019;j_:lU\r\u001e5pI\u0006Qr-\u001a;KoR|\u0015)\u001e;ieQ{7.\u001a8WC2LG-\u0019;peV\u0011!\u0011\u000e\t\u0007\u0005;\u0012YGa\u001c\n\t\t5$q\f\u0002\u0015\u001f\u0006+H\u000f\u001b\u001aU_.,gNV1mS\u0012\fGo\u001c:\u0011\t\u0005m$\u0011O\u0005\u0005\u0005g\niHA\u0002KoR\f\u0011D^1mS\u0012\fG/Z(jI\u000e\u001cuN\u001c4jOV\u0014\u0018\r^5p]R\u0011!\u0011\u0010\t\u0004W\tm\u0014b\u0001B?Y\t!QK\\5u\u0003u9W\r^#se>\u0014X*Z:tC\u001e,gi\u001c:QY\u0006\u001cW\r[8mI\u0016\u0014H\u0003\u0002B\u001f\u0005\u0007CqA!\"\u001b\u0001\u0004\u0011i$A\u0006qY\u0006\u001cW\r[8mI\u0016\u0014\bf\u0002\u0001\u0003\n\n=%\u0011\u0013\t\u0004\u0007\n-\u0015b\u0001BG\t\ni1i\\7q_:,g\u000e^*dC:\fQA^1mk\u0016d#Aa%\"\u0005\tU\u0015aJ2p[:BXMY5bY\u0006\u00147O\f=mI\u0016\u0004Hn\\=/CV$\bNL8jI\u000et3m\u001c8gS\u001eD3\u0001\u0001BM!\r\u0019%1T\u0005\u0004\u0005;#%!D\"p]\u001aLw-\u001e:bi&|g\u000eK\u0002\u0001\u0005C\u0003BAa)\u000326\u0011!Q\u0015\u0006\u0005\u0005O\u0013I+A\u0007d_:4\u0017nZ;sCRLwN\u001c\u0006\u0005\u0003\u000f\u0011YKC\u0002F\u0005[S1Aa,j\u0003\u0019\u0019wN\u001c4jO&!!1\u0017BS\u0005E)e.\u00192mK^+'mU3dkJLG/\u001f\u0015\f\u0001\t]&1\u001aBg\u0005'\u0014)\u000e\u0005\u0003\u0003:\n\u001dWB\u0001B^\u0015\u0011\u0011iLa0\u0002\u0013\r|g\u000eZ5uS>t'\u0002\u0002Ba\u0005\u0007\fQ\"Y;u_\u000e|gNZ5hkJ,'b\u0001Bc\u0011\u0006!!m\\8u\u0013\u0011\u0011IMa/\u0003+\r{g\u000eZ5uS>t\u0017\r\\(o!J|\u0007/\u001a:us\u0006!a.Y7fY\t\u0011y-\t\u0002\u0003R\u0006!C-\u001a9m_ft3/\u001a:wKJt3/Z2ve&$\u0018PL1vi\"t\u0003O]8wS\u0012,'/A\u0006iCZLgn\u001a,bYV,\u0017%A\u0010")
public class OpenIdConnectConfig
implements Logging {
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        OpenIdConnectConfig openIdConnectConfig = this;
        synchronized (openIdConnectConfig) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Bean
    public OidcConfig oidcConfig() {
        return new OidcConfig(ConfigLoader$.MODULE$.loadWithDynamic(ConfigurationHolder$.MODULE$.get(), ConfigLoader$.MODULE$.loadWithDynamic$default$2()), ServerConfiguration.getInstance());
    }

    @Bean
    public LoginProvider oidcLoginProvider() {
        return new LoginProvider(this.oidcConfig().loginMethodDescription(), new StringBuilder(1).append(".").append(this.oidcConfig().external_login()).toString(), "./logout", false);
    }

    @Bean
    public LoginProvider localLoginProvider() {
        return new LoginProvider("XL Deploy local login", "./login", "./logout", true);
    }

    @Bean
    public InMemoryClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.clientRegistration()});
    }

    @Bean
    public DefaultClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.oidcConfig().rolesClaimName());
    }

    @Bean
    @Autowired
    public CustomAuthorizationRequestResolver customAuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        return new CustomAuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
    }

    @Bean
    @Autowired
    public InMemoryOAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    @Autowired
    public XLOidcUserService xlOidcUserService(ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        return new XLOidcUserService(claimsToGrantedAuthoritiesPolicy);
    }

    @Bean
    @Autowired
    public AuthenticatedPrincipalOAuth2AuthorizedClientRepository authorizedClientRepository(OAuth2AuthorizedClientService authorizedClientService) {
        return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        void var3_3;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(this.clientHttpRequestFactory());
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().idTokenJWSAlg(), "idTokenJWSAlg");
        CustomOidcIdTokenDecoderFactory idTokenDecoderFactory = new CustomOidcIdTokenDecoderFactory();
        idTokenDecoderFactory.setJwsAlgorithmResolver(x$1 -> jwsAlgorithm);
        idTokenDecoderFactory.setRestOperations((RestOperations)restTemplate);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtDecoder jwtDecoder() {
        void var3_9;
        NimbusJwtDecoder nimbusJwtDecoder;
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().accessTokenJWSAlg(), "jwsAlg");
        JwsAlgorithm jwsAlgorithm2 = jwsAlgorithm;
        if (jwsAlgorithm2 instanceof SignatureAlgorithm) {
            SignatureAlgorithm signatureAlgorithm = (SignatureAlgorithm)jwsAlgorithm2;
            String jwkSetUri = Strings.isNotBlank((String)this.oidcConfig().accessTokenKeyUri()) ? this.oidcConfig().accessTokenKeyUri() : this.clientRegistration().getProviderDetails().getJwkSetUri();
            nimbusJwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(signatureAlgorithm).build();
        } else if (jwsAlgorithm2 instanceof MacAlgorithm) {
            MacAlgorithm macAlgorithm = (MacAlgorithm)jwsAlgorithm2;
            scala.collection.immutable.Map mappings = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MacAlgorithm.HS256), (Object)"HmacSHA256"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MacAlgorithm.HS384), (Object)"HmacSHA384"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MacAlgorithm.HS512), (Object)"HmacSHA512")}));
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenSecretKey()), (String)"No configuration setting found for key 'deploy.security.auth.providers.oidc.access-token.secretKey'", (Object[])new Object[0]);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.oidcConfig().accessTokenSecretKey().getBytes(StandardCharsets.UTF_8), (String)mappings.get((Object)macAlgorithm));
            nimbusJwtDecoder = NimbusJwtDecoder.withSecretKey((SecretKey)secretKeySpec).macAlgorithm(macAlgorithm).build();
        } else {
            throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
        }
        NimbusJwtDecoder jwtDecoder = nimbusJwtDecoder;
        jwtDecoder.setJwtValidator(this.getJwtOAuth2TokenValidator());
        return var3_9;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtAuthenticationConverter jwtAuthenticationConverter() {
        void var1_1;
        JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
        jwtAuthenticationConverter.setPrincipalClaimName(this.oidcConfig().userNameClaimName());
        jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)new GrantedAuthoritiesExtractor((ClaimsToGrantedAuthoritiesPolicy)this.claimsToGrantedAuthoritiesPolicy()));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient() {
        void var3_3;
        ListBuffer messageConverter = new ListBuffer();
        messageConverter.$plus$eq((Object)new FormHttpMessageConverter());
        messageConverter.$plus$eq((Object)new OAuth2AccessTokenResponseHttpMessageConverter());
        RestTemplate restTemplate = new RestTemplate(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)messageConverter.toList()).asJava());
        restTemplate.setRequestFactory(this.clientHttpRequestFactory());
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
        authorizationCodeTokenResponseClient.setRestOperations((RestOperations)restTemplate);
        return var3_3;
    }

    @Bean
    public AuthenticationFailureHandler oidcLoginFailureHandler() {
        return (x$2, response, x$3) -> response.sendRedirect(this.oidcConfig().external_login());
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler xldLoginFailureHandler() {
        return new SimpleUrlAuthenticationFailureHandler();
    }

    @Bean
    @Autowired
    public OidcLogoutSuccessHandler openIdLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        return new OidcLogoutSuccessHandler(clientRegistrationRepository, this.oidcConfig().postLogoutRedirectUri(), "/login");
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(this.oidcConfig().external_login());
    }

    private ClientRegistration clientRegistration() {
        BoxedUnit boxedUnit;
        ClientRegistration.Builder clientRegistrationBuilder = this.getClientRegistrationBuilder();
        ClientAuthenticationMethod authenticationMethod = this.getClientAuthMethod();
        clientRegistrationBuilder.clientId(this.oidcConfig().clientId()).clientAuthenticationMethod(authenticationMethod).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUri(this.oidcConfig().redirectUri()).userInfoUri("").scope(this.oidcConfig().scopes()).userNameAttributeName(this.oidcConfig().userNameClaimName());
        ClientAuthenticationMethod clientAuthenticationMethod = authenticationMethod;
        ClientAuthenticationMethod clientAuthenticationMethod2 = ClientAuthenticationMethod.NONE;
        if (clientAuthenticationMethod == null ? clientAuthenticationMethod2 != null : !clientAuthenticationMethod.equals(clientAuthenticationMethod2)) {
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().clientSecret()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.clientSecret"), (Object[])new Object[0]);
            boxedUnit = clientRegistrationBuilder.clientSecret(this.oidcConfig().clientSecret());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()) ? clientRegistrationBuilder.authorizationUri(this.oidcConfig().userAuthorizationUri()) : BoxedUnit.UNIT;
        Object object2 = Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()) ? clientRegistrationBuilder.tokenUri(this.oidcConfig().accessTokenUri()) : BoxedUnit.UNIT;
        Object object3 = Strings.isNotBlank((String)this.oidcConfig().jwks_uri()) ? clientRegistrationBuilder.jwkSetUri(this.oidcConfig().jwks_uri()) : BoxedUnit.UNIT;
        ClientRegistration clientRegistration = clientRegistrationBuilder.build();
        Map configurationMetadata = clientRegistration.getProviderDetails().getConfigurationMetadata();
        HashMap<String, String> updatedConfigurationMetadata = new HashMap<String, String>(configurationMetadata);
        updatedConfigurationMetadata.put("rolesClaim", this.oidcConfig().rolesClaimName());
        Object object4 = Strings.isNotBlank((String)this.oidcConfig().logoutUri()) ? updatedConfigurationMetadata.put("end_session_endpoint", this.oidcConfig().logoutUri()) : BoxedUnit.UNIT;
        return ClientRegistration.withClientRegistration((ClientRegistration)clientRegistration).providerConfigurationMetadata(updatedConfigurationMetadata).build();
    }

    private ClientRegistration.Builder getClientRegistrationBuilder() {
        ClientRegistration.Builder builder;
        try {
            if (!this.oidcConfig().issuer().matches("\\S+")) {
                throw new UnsupportedOidcConfigurationException(new StringBuilder(148).append("Whitespace characters in issuer url [").append(this.oidcConfig().issuer()).append("] is not supported. Recommendation is to avoid using spaces in URLs, and instead use hyphens to separate words.").toString());
            }
            builder = ClientRegistrations.fromOidcIssuerLocation((String)this.oidcConfig().issuer()).registrationId(this.oidcConfig().registrationId());
        }
        catch (RuntimeException re) {
            RuntimeException runtimeException = re;
            if (runtimeException instanceof IllegalArgumentException) {
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(62).append("Unable to resolve Configuration with the provided Issuer of [").append(this.oidcConfig().issuer()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (runtimeException instanceof UnsupportedOidcConfigurationException) {
                this.logger().warn((Function0 & Serializable)() -> re.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)runtimeException);
            }
            this.validateOidcConfiguration();
            builder = ClientRegistration.withRegistrationId((String)this.oidcConfig().registrationId());
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private ClientHttpRequestFactory clientHttpRequestFactory() {
        void var1_1;
        block0: {
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            if (!Strings.isNotEmpty((String)this.oidcConfig().proxyHost())) break block0;
            requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.oidcConfig().proxyHost(), Predef$.MODULE$.Integer2int(this.oidcConfig().proxyPort()))));
        }
        return var1_1;
    }

    private JwsAlgorithm getJwsAlgorithm(String jwsAlgorithm, String propertyName) {
        scala.collection.immutable.Map jwsAlgorithms = (scala.collection.immutable.Map)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])SignatureAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])MacAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return (JwsAlgorithm)jwsAlgorithms.getOrElse((Object)jwsAlgorithm, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(77).append(propertyName).append(" value [").append(jwsAlgorithm).append("] is not supported. Ensure you have configured a valid JWS Algorithm.").toString());
        });
    }

    private ClientAuthenticationMethod getClientAuthMethod() {
        scala.collection.immutable.Map clientAuthMethods = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_basic"), (Object)ClientAuthenticationMethod.BASIC), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_post"), (Object)ClientAuthenticationMethod.POST), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"none"), (Object)ClientAuthenticationMethod.NONE)}));
        return (ClientAuthenticationMethod)clientAuthMethods.getOrElse((Object)this.oidcConfig().clientAuthMethod().toLowerCase(), (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(108).append("clientAuthMethod value [").append(this.oidcConfig().clientAuthMethod()).append(" is not supported. Ensure you have configured a valid client authentication method.]").toString());
        });
    }

    private OAuth2TokenValidator<Jwt> getJwtOAuth2TokenValidator() {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(new JwtIssuerValidator(Strings.isNotBlank((String)this.oidcConfig().accessTokenIssuer()) ? this.oidcConfig().accessTokenIssuer() : this.oidcConfig().issuer()));
        validators.add(new JwtClaimValidator("aud", aud -> aud.contains(Strings.isNotBlank((String)this.oidcConfig().accessTokenAudience()) ? this.oidcConfig().accessTokenAudience() : this.oidcConfig().clientId())));
        return new DelegatingOAuth2TokenValidator(validators);
    }

    private void validateOidcConfiguration() {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.userAuthorizationUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.accessTokenUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().jwks_uri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.keyRetrievalUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().logoutUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.logoutUri"), (Object[])new Object[0]);
    }

    public String getErrorMessageForPlaceholder(String placeholder) {
        return new StringBuilder(41).append("No configuration setting found for key '").append(placeholder).append("'").toString();
    }

    public OpenIdConnectConfig() {
        Logging.$init$((Logging)this);
    }
}

