import json
import yaml
from xld.xlyaml.dumper import yaml_safe_dump
from xld.xlyaml.loader import yaml_safe_load

from com.xebialabs.deployit.plugin.api.reflect import Type


class GenerateDeployables(object):
    def __init__(self, ci_id, vars):
        self.ci_id = ci_id
        self.repo = vars['repositoryService']
        self.template_path = self.repo.read(ci_id).file.path
        self.resource_descriptor = Type.valueOf(
            "aws.cloudformation.Resource").descriptor

    def create_resource(self, resource):
        ci = self.resource_descriptor.newInstance(
            "%s/%s" % (self.ci_id, resource.name))
        ci.setProperty('content', resource.content)
        print "Creating CI: %s" % ci.id
        self.repo.create([ci])

    def process(self):
        template = Template(self.template_path)
        if 'Resources' in template.dict:
            for key, value in template.dict['Resources'].items():
                resource = Resource(value['Type'].replace(
                    "::", "-") + '-' + key, template.dump(value))
                self.create_resource(resource)


class Template(object):
    def __init__(self, path):
        with open(path, 'r') as f:
            # Adding quotes safely in case there are placeholders '{{ }}' in the yaml file
            data = f.read()
        self.is_json = True
        if path.endswith('yaml') or path.endswith('yml'):
            self.dict = yaml_safe_load(data)
            self.is_json = False
        else:
            self.dict = json.loads(data)

    def dump(self, _dict):
        if self.is_json:
            return json.dumps(_dict, indent=4, sort_keys=True)
        else:
            return yaml_safe_dump(_dict)


class Resource(object):
    def __init__(self, name, content):
        self.name = name
        self.content = content


GenerateDeployables(thisCi.id, locals()).process()
