from auto_scaling.group.builders.asg_builder import AsgParamsBuilder
from auto_scaling.group.helpers.core_helper import AutoScalingGroupHelper
from commons.aws_helper import AWSHelper


class TagsHelper(AWSHelper):
    def __init__(self, deployed, previous_deployed=None):
        super(TagsHelper, self).__init__(deployed)
        self.__client = self.get_aws_client(region=deployed.region, resource_name='autoscaling')
        self.__previous_deployed = previous_deployed
        self.__asg_helper = AutoScalingGroupHelper(deployed)

    def update_tags(self):
        tags_to_update = self.get_tags_to_be_updated()
        print "Updating tags {0} of auto scaling group {1} on {2}".format(tags_to_update,
                                                                          self.__asg_helper.get_asg_name(),
                                                                          self.deployed.container.name)
        return self.__client.create_or_update_tags(Tags=tags_to_update)

    def delete_tags(self):
        tags_to_delete = self.get_tags_to_be_deleted()

        print "Deleting tags {0} of auto scaling group {1} on {2}".format(tags_to_delete,
                                                                          self.__asg_helper.get_asg_name(),
                                                                          self.deployed.container.name)
        return self.__client.delete_tags(Tags=tags_to_delete)

    def are_tags_modified(self):
        return bool(self.get_tags_to_be_updated() or self.get_tags_to_be_deleted())

    def get_tags_to_be_deleted(self):
        tags = dict(
            (key, value) for key, value in self.__previous_deployed.asgTags.iteritems() if
            key not in self.deployed.asgTags)
        return AsgParamsBuilder(self.__previous_deployed).with_tags(tags).build()['Tags']

    def get_tags_to_be_updated(self):
        tags = dict(
            (key, value) for key, value in self.deployed.asgTags.iteritems() if
            key not in self.__previous_deployed.asgTags or self.__previous_deployed.asgTags[
                key] != value)
        return AsgParamsBuilder(self.deployed).with_tags(tags).build()['Tags']
