from commons.aws_helper import AWSHelper


class ECRHelper(AWSHelper):
    def __init__(self, deployed):
        super(ECRHelper, self).__init__(deployed)
        self.ecr_client = self.get_aws_client(resource_name='ecr', region=deployed.region)

    def create_repository(self):
        print "Creating ECR repository {} on {}".format(self.__get_repository_name(), self.deployed.container.name)
        return self.ecr_client.create_repository(repositoryName=self.__get_repository_name())['repository']

    def set_repository_policy(self):
        print "Setting policy on ECR repository {}".format(self.__get_repository_name())
        self.ecr_client.set_repository_policy(repositoryName=self.__get_repository_name(),
                                              policyText=self.deployed.policy, force=self.deployed.forcePolicy)

    def delete_repository(self):
        print "Deleting ECR repository {} on {}".format(self.__get_repository_name(), self.deployed.container.name)
        self.ecr_client.delete_repository(repositoryName=self.__get_repository_name(), force=self.deployed.forceDelete)

    def delete_repository_policy(self):
        print "Deleting policy on ECR repository {}".format(self.__get_repository_name())
        self.ecr_client.delete_repository_policy(repositoryName=self.__get_repository_name())

    def __get_repository_name(self):
        return self.deployed.repositoryName if self.deployed.repositoryName else self.deployed.name
