from cloudformation.utils.cf_client import CFClient


def process(task_vars):
    deployed = task_vars['deployed']
    context = task_vars['context']

    client = CFClient.new_instance(deployed.container)
    try:
        if client.wait_for_ready_status(deployed, context):
            print("Stack '%s' complete." % deployed.name)
        else:
            raise Exception("Stack '%s' failed to complete." % deployed.name)
    finally:
        client.print_resources(deployed)


if __name__ == '__main__' or __name__ == '__builtin__':
    process(locals())
