from sets import Set

ecs_service_properties = [
    'serviceName',
    'role',
    'taskPlacementTemplateName',
    'taskRole',
    'executionRole',
    'networkMode',
    'volumes',
    'launchType',
    'cpu',
    'memory',
    'subnets',
    'securityGroups',
    'assignPublicIp',
    {
        'name': 'loadBalancers',
        'properties': ['targetGroupArn', 'loadBalancerName', 'containerName', 'containerPort']
    },
    {
        'name': 'containerDefinitions',
        'properties': [
            'containerName', 'image', 'hardMemoryLimit', 'softMemoryLimit', 'links', 'command',
            {
                'name': 'mountPoints',
                'properties': ['sourceVolume', 'containerPath', 'readOnly']
            },
            {
                'name': 'portMappings',
                'properties': ['hostPort', 'containerPort', 'protocol']
            },
            {
                'name': 'logConfiguration',
                'properties': ['logDriver', 'options']
            }
        ]
    }
]


def ci_changed(old_ci, new_ci, properties=ecs_service_properties):
    for property in properties:
        if isinstance(property, dict):
            tmp_old_ci = old_ci.getProperty(property['name'])
            tmp_new_ci = new_ci.getProperty(property['name'])
            if isinstance(tmp_old_ci, list) or isinstance(tmp_old_ci, set) or isinstance(tmp_old_ci, Set):
                if len(tmp_old_ci) != len(tmp_new_ci):
                    return True
                for ci in tmp_old_ci:
                    same_name_cis = [item for item in tmp_new_ci if item.name == ci.name]
                    if len(same_name_cis) == 0 or ci_changed(ci, same_name_cis[0], property['properties']):
                        return True
            elif ci_changed(tmp_old_ci, tmp_new_ci, property['properties']):
                return True
        elif property_changed(old_ci.getProperty(property), new_ci.getProperty(property)):
            return True
    return False


def property_changed(old_property, new_property):
    if isinstance(old_property, list) or isinstance(old_property, set) or isinstance(old_property, Set):
        if len(old_property) != len(new_property):
            return True
        for prop in old_property:
            if prop not in new_property:
                return True
    elif isinstance(old_property, dict):
        if len(old_property) != len(new_property):
            return True
        for key, value in old_property.iteritems():
            if key not in new_property or value != new_property[key]:
                return True
    else:
        return old_property != new_property
