from java.io import BufferedReader
from java.io import InputStreamReader
from java.io import ByteArrayInputStream
from java.lang import StringBuilder
from java.lang import RuntimeException
from java.lang import String
from com.xebialabs.deployit.plugin.api.reflect import Type
import json

class TemplateHelper(object):
    def __init__(self, deployed, context, stitch = None):
        self.__deployed = deployed
        self.__context = context
        self.__stitch = stitch

    def transform_template(self):
        parameters, template = self.read_stack_file()
        if self.__stitch is not None and self.__deployed.type.instanceOf(Type.valueOf("aws.cloudformation.DeployedTemplate")):
            try:
                try:
                    json.loads(template)
                    format = "json"
                except:
                    format = "yaml"

                invocation_name = "Transform {} template".format(self.__deployed.name)
                transformer_context = {"format": format, "invocationName": invocation_name}
                transformed_content = self.__stitch(ByteArrayInputStream(String(template).getBytes()), transformer_context)
                print('Template transformation applied for {}'.format(self.__deployed.name))
                return parameters, self.stringify(transformed_content)
            except RuntimeException as e:
                if e.getMessage() is not None:
                    msg = e.getMessage
                else:
                    msg = e.toString
                print("Planning script could not apply template transformation. Reason: {}".format(msg))
                return parameters, template
        else:
            return parameters, template

    def read_stack_file(self):
        # get content of cf file
        with open(self.__deployed.file.path, 'r') as tfile:
            template = tfile.read()
        parameters = []
        for k in self.__deployed.inputVariables:
            param = {}
            param['ParameterKey'] = k
            param['ParameterValue'] =self.__deployed.inputVariables[k]
            parameters.append(param)
        return parameters, template

    def stringify(self, stream):
        reader = BufferedReader(InputStreamReader(stream))
        out = StringBuilder()

        while True:
            line = reader.readLine()
            if line is None:
                break
            out.append(line)
            out.append("\n")

        reader.close()
        return out.toString()
