from cloudformation.utils.cf_client import CFClient


def process(task_vars):
    deployed = task_vars['previousDeployed'] if 'previousDeployed' in task_vars else task_vars['thisCi']

    client = CFClient.new_instance(deployed.container)
    if client.destroy_stack(deployed):
        print("Stack '%s' destroyed successfully." % deployed.name)
    else:
        print("Stack '%s' does not exists. Ignoring." % deployed.name)


if __name__ == '__main__' or __name__ == '__builtin__':
    process(locals())
