from commons.aws_helper import AWSHelper

class S3Helper(AWSHelper):
    def __init__(self, deployed):
        super(S3Helper, self).__init__(deployed)
        self.s3_client = self.get_aws_client(resource_name='s3', region=self.deployed.region)


    def create_s3_bucket(self):
        print "Creating S3 bucket..."
        kwargs = {}
        if self.deployed.region != 'us-east-1':
            kwargs = {'CreateBucketConfiguration': {'LocationConstraint': self.deployed.region}}
        create_response = self.s3_client.create_bucket(Bucket=self.deployed.bucketName, **kwargs)
        return create_response

    def put_s3_bucket_policy(self):
        print "Putting S3 bucket Policy on bucket {0}...".format(self.deployed.bucketName)
        policy_response = self.s3_client.put_bucket_policy(
            Bucket=self.deployed.bucketName,
            Policy=self.deployed.policy
        )
        if self.is_success(policy_response):
            print "Bucket Policy updated."

    def delete_s3_bucket_policy(self):
        print "Deleting S3 bucket Policy on bucket {0}...".format(self.deployed.bucketName)
        policy_response = self.s3_client.delete_bucket_policy(
            Bucket=self.deployed.bucketName
        )
        if self.is_success(policy_response):
            print "Bucket Policy deleted."

    def set_bucket_website_hosting(self):
        print "Setting S3 bucket website hosting..."
        hosting_response = self.s3_client.put_bucket_website(
            Bucket=self.deployed.bucketName,
            WebsiteConfiguration={
                'ErrorDocument': {
                    'Key': self.deployed.errorDocument
                },
                'IndexDocument': {
                    'Suffix': self.deployed.indexDocument
                }
            }
        )
        return hosting_response

    def set_bucket_logging(self):
        print "Setting S3 bucket logging..."
        logging_response = self.s3_client.put_bucket_logging(
            Bucket=self.deployed.bucketName,
            BucketLoggingStatus={
                'LoggingEnabled': {
                    'TargetBucket': self.deployed.targetBucket,
                    'TargetPrefix': self.deployed.targetPrefix
                }
            },
        )
        return logging_response

    def delete_s3_bucket(self):
        print("Deleting S3 bucket '{}'...".format(self.deployed.bucketName))
        delete_response = self.s3_client.delete_bucket(
            Bucket=self.deployed.bucketName
        )
        return delete_response

    def disable_bucket_logging(self):
        print "Disabling S3 bucket logging..."
        logging_response = self.s3_client.put_bucket_logging(
            Bucket=self.deployed.bucketName,
            BucketLoggingStatus={}
        )
        return logging_response

    def disable_bucket_website_hosting(self):
        print "Disabling S3 bucket website hosting..."
        hosting_response = self.s3_client.delete_bucket_website(
            Bucket=self.deployed.bucketName)
        return hosting_response
