from alb.tg.tg_helper import TargetGroupHelper

tg_helper = TargetGroupHelper(deployed, previousDeployed)
target_name = deployed.targetName if deployed.targetName else deployed.name

# Validate target group modification
tg_helper.validate_target_group_modification()

# Configure target group
if tg_helper.should_modify_target_group() or tg_helper.should_modify_target_group_attributes():
    # Validate target group
    tg_helper.validate_target_group()
    context.addStepWithCheckpoint(steps.jython(
        description="Configure target group {} on {}".format(target_name, deployed.container.name),
        script="alb/tg/steps/configure_target_group.py",
        order=87
    ), delta)

# Associate instances
if deployed.instances:
    context.addStepWithCheckpoint(steps.jython(
        description="Associate instances to target group {} on {}".format(target_name, deployed.container.name),
        script="alb/tg/steps/associate_instances.py",
        order=87
    ), delta)

# Dissociate istances
if previousDeployed.instances:
    context.addStepWithCheckpoint(steps.jython(
        description="Dissociate instances from target group {} on {}".format(target_name, deployed.container.name),
        script="alb/tg/steps/dissociate_instances.py",
        order=15
    ), delta)
