from auto_scaling.group.helpers.core_helper import AutoScalingGroupHelper
from auto_scaling.group.validator import AutoScalingValidator
from commons.aws_helper import AWSHelper
from ec2.ec2_helper import EC2Helper


class LaunchConfigHelper(AWSHelper):
    def __init__(self, deployed, previous_deployed=None):
        super(LaunchConfigHelper, self).__init__(deployed)
        self.__previous_deployed = previous_deployed
        self.__client = self.get_aws_client(region=deployed.region, resource_name='autoscaling')
        self.__ec2_helper = EC2Helper(deployed)
        self.__asg_helper = AutoScalingGroupHelper(deployed, previous_deployed)
        self.__validator = AutoScalingValidator(deployed, previous_deployed)

    def create(self, version_id):
        self.deployed.launchConfigurationName = self.__get_lc_name(version_id)
        print "Creating launch configuration {0} on {1}".format(self.deployed.launchConfigurationName,
                                                                self.deployed.container.name)
        security_group_ids = self.__ec2_helper.get_security_group_id_list(
            self.deployed.launchConfigurationSecurityGroups) if self.deployed.launchConfigurationSecurityGroups else None
        params = {"LaunchConfigurationName": self.deployed.launchConfigurationName,
                  "InstanceId": self.__ec2_helper.get_instance_id_by_id_or_name(self.deployed.launchConfigurationInstanceId),
                  "ImageId": self.__ec2_helper.get_ami_id_by_id_or_name(self.deployed.launchConfigurationAMIId),
                  "InstanceType": self.deployed.launchConfigurationInstanceType,
                  "UserData": self.deployed.launchConfigurationUserData,
                  "SecurityGroups": security_group_ids}
        params = self.remove_none_keys(params)
        return self.__client.create_launch_configuration(**params)

    def create_launch_configuration_using_instance(self):
        return self.__client.create_launch_configuration(
            LaunchConfigurationName=self.deployed.launchConfigurationName,
            InstanceId=self.__ec2_helper.get_instance_id_by_id_or_name(self.deployed.launchConfigurationInstanceId)
        )

    def create_launch_configuration_using_ami(self):
        return self.__client.create_launch_configuration(
            LaunchConfigurationName=self.deployed.launchConfigurationName,
            ImageId = self.deployed.launchConfigurationAMIId,
            InstanceType = self.deployed.launchConfigurationInstanceType
        )

    def __get_lc_name(self, version_id):
        return "LaunchConfig_{0}_{1}".format(self.__asg_helper.get_asg_name(), LaunchConfigHelper.get_version(version_id))

    def __get_by_name(self):
        return self.__client.describe_launch_configurations(
            LaunchConfigurationNames=[self.deployed.launchConfigurationName]
        )

    def save_arn(self):
        arn = self.__get_by_name()['LaunchConfigurations'][0]['LaunchConfigurationARN']
        self.deployed.launchConfigArn = arn

    def delete(self):
        print "Deleting launch configuration {0} on {1}".format(self.__previous_deployed.launchConfigurationName,
                                                                self.__previous_deployed.container.name)
        return self.__client.delete_launch_configuration(
            LaunchConfigurationName=self.__previous_deployed.launchConfigurationName
        )

    @staticmethod
    def get_version(version_id):
        return version_id.split('/').pop()
