if previousDeployed:
    if deployed.bucketName != previousDeployed.bucketName:
        raise RuntimeError("Bucket name can not be updated once created.")
    if deployed.region != previousDeployed.region:
        raise RuntimeError("Bucket region can not be updated once created.")
    context.addStep(steps.jython(
        description="Modify bucket %s on %s" % (deployed.bucketName, deployed.container.name),
        script="s3/modify_bucket.py",
        order=60
    ))
else:
    context.addStepWithCheckpoint(steps.jython(
        description="Create bucket %s on %s" % (deployed.bucketName, deployed.container.name),
        script="s3/create_bucket.py",
        order=60,
        jython_context = {"deployed": deployed}
    ), delta)

    if deployed.policy and deployed.policy.strip():
        context.addStep(steps.jython(
            description="Attach policy on bucket %s" % (deployed.bucketName),
            script="s3/create_bucket_policy.py",
            order=61
        ))



