from ec2.vpc.routes.route_table_helper import RouteHelper

route_table_helper = RouteHelper(deployed)

route_table_name = deployed.routeTableName if deployed.routeTableName else deployed.name
previous_deployed_route_table_name = previousDeployed.routeTableName if previousDeployed.routeTableName else previousDeployed.name

if route_table_name != previous_deployed_route_table_name:
    route_table_helper.set_resource_name(deployed.routeTableId, route_table_name)
    print "Modified name of the route table (id: %s) to %s" % (deployed.routeTableId, route_table_name)

if not set(previousDeployed.subnets) == set(deployed.subnets):
    subnets_to_remove = list(set(previousDeployed.subnets) - set(deployed.subnets))
    subnets_to_add = list(set(deployed.subnets) - set(previousDeployed.subnets))
    route_table_helper.disassociate_subnets(subnets_to_remove)
    route_table_helper.associate_subnets(subnets_to_add)
