import time

from ec2.ec2_helper import EC2Helper


class EC2AmiHelper(EC2Helper):
    def __init__(self, deployed):
        super(EC2AmiHelper, self).__init__(deployed)

    def create_ami(self, ami_name):
        final_ami_name = ami_name if bool(ami_name and ami_name.strip()) else (self.__get_instance_name())
        print "Creating AMI for instance id '{0}' with AMI name '{1}' ".format(self.deployed.instanceId, final_ami_name)
        ami_id = self.ec2_client.create_image(InstanceId=self.deployed.instanceId
                                              , Name=final_ami_name
                                              , Description="AMI create from ec2 plugin "
                                              , NoReboot=True, DryRun=False)['ImageId']
        print "Adding name tag '{0}' with value '{1}' to AMI '{2}' ".format('Name', final_ami_name, ami_id)
        self.add_tag(ami_id, 'Name', final_ami_name)
        return ami_id

    def __get_instance_name(self):
        return self.deployed.instanceName if self.deployed.instanceName else self.deployed.name

    def add_tag(self, resource_id, tag_name, tag_value):
        self.ec2_client.create_tags(
            Resources=[resource_id],
            Tags=[{'Key': tag_name, 'Value': tag_value}, ])

    def wait_till_ami_is_available(self, ami_id):
        while True:
            print "Waiting for AMI to be available."
            time.sleep(5)
            if self.ec2_client.describe_images(ImageIds=[ami_id])['Images'][0]['State'] == 'available':
                print "AMI with id {0} is available to use.".format(ami_id)
                return

    def save_ami_id(self, repository_service, ami_id):
        print "Saving AMI {0} as output property".format(ami_id)
        ami_ids = self.deployed['amiIds']
        ami_ids.append(ami_id)
        self.deployed.amiIds = ami_ids
        repository_service.update([self.deployed])
