from auto_scaling import *
from ec2.ec2_helper import EC2Helper


class VpcHelper:
    def __init__(self, deployed, previous_deployed=None):
        self.__previous_deployed = previous_deployed
        self.__deployed = deployed
        self.__ec2_helper = EC2Helper(deployed)

    def are_new_availability_zones_attached(self):
        return bool(self.get_new_attached_availability_zones())

    def get_new_attached_availability_zones(self):
        return (self.__deployed.availabilityZones,
                self.__deployed.availabilityZones - self.__previous_deployed.availabilityZones)[
            bool(self.__previous_deployed)]

    def are_availability_zones_detached(self):
        return bool(self.get_detached_availability_zones())

    def get_detached_availability_zones(self):
        return self.__previous_deployed.availabilityZones - self.__deployed.availabilityZones

    def get_remaining_availability_zones(self):
        return get_common_elements(self.__previous_deployed.availabilityZones, self.__deployed.availabilityZones)

    def are_subnets_modified(self):
        return VpcHelper.is_set_modified(cur=self.__deployed.subnetIds, prev=self.__previous_deployed.subnetIds)

    def are_new_subnets_attached(self):
        return bool(self.get_new_attached_subnets())

    def are_availability_zones_modified(self):
        return VpcHelper.is_set_modified(cur=self.__deployed.availabilityZones,
                                         prev=self.__previous_deployed.availabilityZones)

    @staticmethod
    def is_set_modified(prev, cur):
        return len(prev - cur) != 0 or len(cur - prev) != 0

    def get_new_attached_subnets(self):
        return (self.__deployed.subnetIds - self.__previous_deployed.subnetIds) if bool(
            self.__previous_deployed) else self.__deployed.subnetIds

    def are_subnets_detached(self):
        return bool(self.get_detached_subnets())

    def get_remaining_subnets(self):
        return get_common_elements(self.__deployed.subnetIds, self.__previous_deployed.subnetIds)

    def get_detached_subnets(self):
        return self.__previous_deployed.subnetIds - self.__deployed.subnetIds

    def get_subnet_ids(self, subnets):
        return self.__ec2_helper.get_subnet_id_list(subnets)
