from ecs import TaskServiceHelper

task_service_helper = TaskServiceHelper(previousDeployed)

task_statuses = task_service_helper.get_task_statuses()
tasks_not_yet_stopped = task_service_helper.filter_tasks_not_stopped(task_statuses)

if tasks_not_yet_stopped:
    retry_count = task_service_helper.get_current_retry_count(context, "{0}_stopped".format(previousDeployed.name))
    if retry_count > previousDeployed.maxTaskWaitRetryCount:
        raise RuntimeError("Reached the maximum limit of {0} retries and some tasks {1} could not be stopped (lastKnownStatus=STOPPED, desiredStatus=STOPPED)"
                           .format(retry_count - 1, tasks_not_yet_stopped))
    else:
        print "Waiting for tasks {0} to be stopped. Done with retry {1}".format(tasks_not_yet_stopped, retry_count)
        result = "RETRY"
        task_service_helper.increment_retry_counter(context, "{0}_stopped".format(previousDeployed.name))
else:
    previousDeployed.taskArns = []
    if deployed:
        deployed.taskArns = []
    print "All tasks stopped."
