
import collections

from com.xebialabs.deployit.plugin.api.reflect import Type

class CIFactory(object):
    def __init__(self, repositoryService, metadataService, cfout):
        self.repositoryService = repositoryService
        self.metadataService = metadataService
        self.cfout = cfout


    @staticmethod
    def new_instance(repositoryService, metadataService, cfout):
        return CIFactory(repositoryService, metadataService, cfout)


    def createCis(self, root, template):
        print "Creating configuration items in '%s'" % root

        # iterate over list of ci definitions in template
        for ci_tmpl in template:
            ci_info = self._replace_str(ci_tmpl)
            self._create_ci(root, ci_info)


    def deleteCis(self, root, template):
        print "Deleting configuration items in '%s'" % root

        for ci_tmpl in reversed(template):
            self._delete_ci(root, ci_tmpl)


    # INTERNAL FUNCTIONS -----------------------------------------

    # scan template for property placeholders, substitute values
    def _replace_str(self, tmpl):
        for k in tmpl:
            val = tmpl[k]
            try:
                # if value is a string, do the replacement if necessary
                if isinstance(val, basestring):
                    if '{' in val:
                        tmpl[k] = val.format(**self.cfout)

                # if the value is a list, iterate over each item and process
                elif type(val) is list:
                    newval = []
                    for item in val:
                        newval.append(self._replace_str(item))
                    tmpl[k] = newval

                # if its iterable, recursively process
                elif isinstance(val, collections.Iterable):
                    tmpl[k] = self._replace_str(val)

            except KeyError:
                print "WARN: Property placeholder '%s' was not found in the output dictionary." % val

        return tmpl


    def _create_ci(self, root, ci_info):
        print "Creating/ Updating '%s' : '%s'" % (ci_info['type'], ci_info['id'])

        id = "%s/%s" % (root, ci_info['id'])
        type_obj = Type.valueOf(ci_info['type'])
        ci_obj = self.metadataService.findDescriptor(type_obj).newInstance(id)

        # populate ci
        for prop in ci_info:
            if prop in ['id', 'type']:
                continue

            val = ci_info[prop]
            if type(val) is list:
                if prop == 'members':
                    properties = set()
                    for v in val:
                        ci = self.repositoryService.read(v['ci ref'])
                        properties.add(Type.valueOf(str(ci.type)).getDescriptor().newInstance(ci.id))
                    ci_obj.setProperty(prop, properties)
                elif prop == 'dictionaries':
                    properties = list()
                    for v in val:
                        ci = self.repositoryService.read(v['ci ref'])
                        properties.append(Type.valueOf(str(ci.type)).getDescriptor().newInstance(ci.id))
                    ci_obj.setProperty(prop, properties)
                else:
                    ci_obj.setProperty(prop, set(val))
            else:
                ci_obj.setProperty(prop, val)


        if self.repositoryService.exists(id):
            self.repositoryService.update(id, ci_obj)
        else:
            self.repositoryService.create(id, ci_obj)


    def _delete_ci(self, root, ci_info):
        print "Deleting '%s' : '%s'" % (ci_info['type'], ci_info['id'])

        id = "%s/%s" % (root, ci_info['id'])
        if not self.repositoryService.exists(id):
            print "CI '%s' already deleted, skipping." % id
            return

        self.repositoryService.delete(id)
