from ec2.vpc.vpc_helper import VPCHelper

vpc_helper = VPCHelper(deployed)

if previousDeployed.vpcName != deployed.vpcName:
    vpc_helper.set_vpc_name(previousDeployed.vpcId, deployed.vpcName if deployed.vpcName else deployed.name)

if previousDeployed.amazonProvidedIpv6CidrBlock != deployed.amazonProvidedIpv6CidrBlock:
    vpc_helper.modify_amazon_vpc_cidr_block()

if previousDeployed.classicLink != deployed.classicLink:
    if deployed.classicLink:
        vpc_helper.enable_vpc_classic_link()
    else:
        vpc_helper.disable_vpc_classic_link()

if previousDeployed.classicLinkDnsSupport != deployed.classicLinkDnsSupport:
    if deployed.classicLinkDnsSupport:
        vpc_helper.enable_vpc_classic_link_dns_support()
    else:
        vpc_helper.disable_vpc_classic_link_dns_support()

if previousDeployed.dnsSupport != deployed.dnsSupport:
    vpc_helper.modify_dns_support()

if previousDeployed.dnsHostnames != deployed.dnsHostnames:
    vpc_helper.modify_dns_host_names()

