from cloudformation.planning_scripts.helper import TemplateHelper

if "stitch" in dir():
    cf_parameters, cf_template = TemplateHelper(deployed, context, stitch).transform_template()
else:
    cf_parameters, cf_template = TemplateHelper(deployed, context).read_stack_file()

context.addStep(steps.jython(
    description="Validate stack {} on {}".format(deployed.name, deployed.container.account.name),
    jython_context={"cf_parameters" : cf_parameters, "cf_template": cf_template},
    script="cloudformation/validate_template.py"
))

context.addStepWithCheckpoint(steps.jython(
    description="Update stack {} on {}".format(deployed.name, deployed.container.account.name),
    jython_context={"cf_parameters" : cf_parameters, "cf_template": cf_template},
    script="cloudformation/update_stack.py"
), delta)

context.addStep(steps.jython(
    description="Wait for stack {} to be fully updated".format(deployed.name),
    script="cloudformation/wait_for_ready.py"
))

context.addStep(steps.jython(
    description="Capture output variables from stack {}".format(deployed.name),
    script="cloudformation/capture_output.py"
))

context.addStep(steps.jython(
    description="Update configuration items for stack {}".format(deployed.name),
    jython_context={"cf_template": cf_template},
    script="cloudformation/create_infrastructure.py"
))
